/* gMUDix -- MUDix for X windows
 * Copyright (c) 2002 Marko Boomstra (m.boomstra@chello.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mudix.h"


void init_history(USER *user)
{
    int i;

    /* just initialize the pointers and set history on NULL */
    user->pCurHist = &user->history[0];
    user->pGetHist = &user->history[0];

    for (i=0; i<MAX_HISTORY; i++) 
    {
	user->history[i] = NULL;
    }
}


void add_to_history(USER *user, gchar *input)
{
    /* do not add short inputs to the history buffer */
    if (g_utf8_strlen(input, -1) < 3)
    {
        return;
    }

    /* free string if it slot was already taken */
    if (*user->pCurHist)
    {
        free(*user->pCurHist);
    }

    /* just duplicate string into the circular history buffer */
    *user->pCurHist = strdup(input);

    /* update current pointer to next entry */
    if (user->pCurHist == &user->history[MAX_HISTORY-1])
    {
        user->pCurHist = user->pGetHist = &user->history[0];
    }
    else
    {
        user->pGetHist = ++user->pCurHist;
    }
}

