#include <stdio.h>
#include <gtk/gtk.h>
#include <gmpc/plugin.h>
#include "qosd.h"
static GtkWidget *gk_window = NULL;
static GdkPixbuf *pb = NULL;
static gchar *utf8;
static guint id=0,id2=0;
static PangoLayout *layout = NULL;
int xpadding = 10, ypadding=10;
GdkPixbuf *qosd_cover_pb = NULL;
double value = 0;
int trans_down(gpointer data);


static int destroy_window()
{
	gtk_widget_destroy(gk_window);
	if(id2)g_source_remove(id2);
	if(id)g_source_remove(id);
	id= 0;
	gk_window = NULL;

	g_object_unref(layout);
	g_object_unref(pb);
	pb = NULL;
	return FALSE;
}

static int close_window()
{
	if(id2)g_source_remove(id2);
	g_timeout_add(FADE_TIME, (GSourceFunc)(trans_down), 0);



}
static void cc_draw_curved_rectangle(cairo_t *cc, int width, int height)
{
	cairo_rectangle(cc,0,0,width,height);
/*
	return 
	
	double radius =height*0.3;
	double pc = radius*(0.133974596);
	cairo_move_to(cc,radius,0);
	cairo_line_to(cc,width-radius,0);

	cairo_curve_to(cc,width-pc,pc, width-pc,pc,width,radius);
	cairo_line_to(cc,width,height-radius);
	cairo_curve_to(cc,width-pc,height-pc, width-pc,height-pc,width-radius,height);
	cairo_line_to(cc,radius,height);
	cairo_curve_to(cc,pc,height-pc,pc,height-pc,0,height-radius);
	cairo_line_to(cc,0,radius);
	cairo_curve_to(cc,pc,pc,pc,pc,radius,0);
	cairo_close_path (cc);
*/
	cairo_fill_preserve(cc);
	cairo_set_source_rgba(cc,1,1,1,value);
	cairo_stroke(cc);
}
static int expose()
{
	int width,height,x_pos, y_pos;
	int text_width, text_height;
	int pb_width, pb_height;
	int xoffset = 0;
	cairo_t *cc = NULL;

	gtk_window_get_size(GTK_WINDOW(gk_window), &width, &height);
	cc = gdk_cairo_create(gk_window->window);

	gdk_cairo_set_source_pixbuf(cc,pb,0,0);
	cairo_paint(cc);


	cairo_set_source_rgba(cc,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "background-rcolor",0)/65535.0,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "background-gcolor",0)/65535.0,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "background-bcolor",0)/65535.0,
			value*((double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "background-acolor", 50000)/65535.0));

	
	cc_draw_curved_rectangle(cc,width,height);

	if(qosd_cover_pb)
	{
		pb_width = gdk_pixbuf_get_width(qosd_cover_pb);;
		pb_height = gdk_pixbuf_get_height(qosd_cover_pb);
		if(height >= (pb_height+ypadding))
		{
			cairo_set_source_rgba(cc,1,1,1,value);
			cairo_rectangle(cc,xpadding/2+4,(height-pb_height)/2,pb_width,pb_height);
			cairo_stroke_preserve(cc);
			cairo_clip(cc);
			gdk_cairo_set_source_pixbuf (cc,qosd_cover_pb,xpadding/2+4,(height-pb_height)/2);
			cairo_paint_with_alpha(cc,value);
			cairo_reset_clip(cc);

			xoffset = 90;
		}
	}


	pango_layout_get_pixel_size(layout, &text_width, &text_height);



	cairo_set_source_rgba(cc,0,0,0,value);
	cairo_move_to(cc,
			xoffset+xpadding/2+2,
			(height-text_height)/2 /*ypadding/2*/+2
		     );
	pango_cairo_show_layout(cc, layout);

	cairo_move_to(cc,
			xoffset+xpadding/2,
			(height-text_height)/2/*-ypadding/2*/
		     );

	cairo_set_source_rgba(cc,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "text-rcolor", 65535)/65535.0,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "text-gcolor", 65535)/65535.0,
			(double)cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "text-bcolor", 65535)/65535.0,
			value*(cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "text-acolor", 65535)/65535.0));

	pango_cairo_show_layout(cc, layout);

	cairo_destroy(cc);
}
/* fade out */
int trans_down(gpointer data)
{
	int reshow = GPOINTER_TO_INT(data);
	if(gk_window == NULL) return FALSE;
	value -=0.2;
	gtk_widget_queue_draw(gk_window);
	if(value <= 0)
	{
		value = 0;
		destroy_window();
		if(reshow)
		{
			gchar *str = g_strdup(utf8);
			qosd_show_popup(str);
			g_free(str);
		}
		return FALSE;
	}
	return TRUE;

}
/* fade in */
static int trans_up()
{
	if(gk_window == NULL)
	{
		id2 = 0;
		return FALSE;
	}
	value +=0.2;
	gtk_widget_queue_draw(gk_window);
	if(value >= 1.0)
	{
		value = 1.0;
		id2=0;
		return FALSE;
	}
	return TRUE;
}

static void reshow_window()
{
	if(id2) {
		g_source_remove(id2);
		id2 = 0;
	}
	g_timeout_add(FADE_TIME, (GSourceFunc)trans_down,GINT_TO_POINTER(1));
}
void qosd_show_popup(gchar *string)
{
	if(utf8) g_free(utf8);
	utf8 = g_strdup(string);


	if(gk_window)
	{
		reshow_window();
		return;
	}
	else
	{
		GdkRectangle msize;
		int screen_w, screen_h;
		int width,height;
		int x,y;
		PangoFontDescription *desc;
		cairo_text_extents_t extents;
		cairo_t *cc = NULL;
		GdkScreen *screen = NULL;
		GdkWindow *root =   NULL;

		/* create the "popup" widow  */
		gk_window = gtk_window_new(GTK_WINDOW_POPUP);

		/* make the window a drawable */
		gtk_widget_set_app_paintable(gk_window, TRUE);
		/* set the expose signal */
		g_signal_connect(G_OBJECT(gk_window), "expose-event", G_CALLBACK(expose), NULL);

		/* always on top */
		gtk_window_set_keep_above(GTK_WINDOW(gk_window), TRUE);

		/* We need to get the root window of the screen the popup is located 
		 * We use this to get the screensize, and to make a screenshot
		 */
		screen = gtk_window_get_screen(GTK_WINDOW(gk_window));
		gdk_screen_get_monitor_geometry(screen, 0,&msize);
		root = gdk_screen_get_root_window(screen);

		/* get the size of the monitor */
//		gdk_drawable_get_size(root, &screen_w, &screen_h);		
		screen_w = msize.width;
		screen_h = msize.height;

		/* to calculate the needed size of the popup we need to create a 
		 * cairo context, and get a pango layout from that.
		 * I cannot take the window as a drawable, because it needs to showed before it's
		 * valid 
		 * TODO: if I make the popup size fixed, I can remove this "hack"
		 */
		/* create cairo context */
		cc = gdk_cairo_create(root);
		/* create pango layout, I am gonna keep this one around to reuse... maybe not the best thing? */
		layout = pango_cairo_create_layout(cc);

		/* set the text */
		pango_layout_set_markup(layout, utf8,-1);
		/* start making a description, so I can configure font size and stuff */
		desc = pango_font_description_new();
		/* set font info */
		pango_font_description_set_weight(desc, PANGO_WEIGHT_BOLD);
		pango_font_description_set_size(desc, 16*PANGO_SCALE);
		pango_layout_set_font_description(layout,desc);
		/* clean up the description */
		pango_font_description_free(desc);
		/* set alignement */
		switch(cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "hposition", 0))
		{
			case 0:
				pango_layout_set_alignment(layout, PANGO_ALIGN_LEFT);
				break;
			case 1:
				pango_layout_set_alignment(layout, PANGO_ALIGN_CENTER);
				break;
			case 2:
				pango_layout_set_alignment(layout, PANGO_ALIGN_RIGHT);
				break;

			default:
				break;
		}


		/* get the size the  string needs */
		pango_layout_get_pixel_size(layout, &width, &height);
		/* if the window is going to be bigger then the actual screen, 
		 * set wrapping. (always setting wrapping will screw up the PANGO_ALIGN_CENTER
		 */
		if(width >= (screen_w-2*xpadding))
		{
			/* set wrapper */
			pango_layout_set_wrap(layout,PANGO_WRAP_CHAR);
			pango_layout_set_width(layout, PANGO_SCALE*(screen_w-2*xpadding));
			/* refetch size */
			pango_layout_get_pixel_size(layout, &width, &height);
		}
		if(qosd_cover_pb){
			height = (height > gdk_pixbuf_get_height(qosd_cover_pb))? height:gdk_pixbuf_get_height(qosd_cover_pb);
			width += 10+gdk_pixbuf_get_width(qosd_cover_pb);
		}
		/* make the popup the needed size */
		gtk_window_resize(GTK_WINDOW(gk_window), width+xpadding, height+ypadding);
		/* calculate screen position */
		switch(cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "hposition", 0))
		{
			case 0:
				x = 0;
				x += msize.x+cfg_get_single_value_as_int_with_default(config, "qosd-plugin","y-offset",0);
				break;
			case 1:
				x = msize.x+screen_w/2-(width+xpadding)/2;

				break;
			case 2:
				x = msize.x+screen_w - (width+xpadding);
				x -= cfg_get_single_value_as_int_with_default(config, "qosd-plugin","y-offset",0);
				break;
			default:
				break;
		}
		switch(cfg_get_single_value_as_int_with_default(config, "qosd-plugin", "vposition", 0))
		{
			case 0:                                                                                   		
				y = msize.y;
				y += cfg_get_single_value_as_int_with_default(config, "qosd-plugin","x-offset",0);
				break;
			case 1:
				y = msize.y+screen_h/2-(height+ypadding)/2;

				break;
			case 2:
				y = msize.y+screen_h - (height+ypadding);
				y -= cfg_get_single_value_as_int_with_default(config, "qosd-plugin","x-offset",0);
				break;
			default:
				break;
		}

		/* cut out the needed part of the screen to function as background.
		 * render this to a pixbuf.. (can this be done more efficient?)
		 */
		pb = gdk_pixbuf_get_from_drawable(NULL,
				root, NULL,
				x,y,0,0,
				width+xpadding,
				height+ypadding);
		/* move the window in place */
		gtk_window_move(GTK_WINDOW(gk_window), x,y);

		/* show the widget */
		gtk_widget_show(gk_window);
		id = g_timeout_add(cfg_get_single_value_as_int_with_default(config, "qosd-plugin","timeout",3)*1000, 
				(GSourceFunc)(close_window), NULL);
		/* fade in effect */
		value = 0;
		id2 = g_timeout_add(FADE_TIME,(GSourceFunc)(trans_up), GINT_TO_POINTER(0));
	}
}

