/* Copyright 2006-2007 Qball <Qball@qballcow.nl>
 *
 * gmpc-lyrics : A lyrics fetcher for GMpc
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "gmpc-lyrics.h"

#define NOT_FOUND "Not found"

int __lyricwiki_get_soap_message(post_message *soap, gchar *artist, gchar *songtitle) {

	/* not enough data to perform search */
	if(!artist || !songtitle)
		return 0;
	
	/* create request */
	GString *msg;
	msg = g_string_new("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
	        "<SOAP-ENV:Envelope SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" "
	        		"xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" "
	        		"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" "
	        		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" "
	        		"xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" "
	        		"xmlns:tns=\"urn:LyricWiki\">\n"
	        		"<SOAP-ENV:Body>\n<tns:getSong xmlns:tns=\"urn:LyricWiki\">\n");

    /* quick fix to get correctly escaped xml */	
    gchar *temp = g_markup_printf_escaped("<artist xsi:type=\"xsd:string\">%s</artist><song xsi:type=\"xsd:string\">%s</song>", artist,songtitle);
    g_string_append(msg, temp);
    g_free(temp);

	g_string_append(msg, "</tns:getSong></SOAP-ENV:Body></SOAP-ENV:Envelope>\n"); 
	soap->body = msg; 
	add_post_header(soap, "SOAPAction: urn:LyricWiki#getSong");
	
	return 1; 
}

gchar * __lyricwiki_get_soap_lyrics(xmlDocPtr xml, int exact) {
	/* no way of knowing if it's exact, nevertheless if it is found it's pretty exact */
	xmlNodePtr root,node; 
	gchar* tmp = NULL; 
	gchar* ret = NULL; 
	
	root = xmlDocGetRootElement(xml);
	
	if(root) {
		int i=0; 
		/* the information we want is burried 4 levels down */
		for(node=root; node && i<4; i++) 
			node=node->xmlChildrenNode;
		node = get_node_by_name (node, (xmlChar *)"lyrics");
		if(node) {
			tmp = (gchar *)xmlNodeGetContent(node);
		} else debug_printf(DEBUG_INFO, "node is null");
	}
	else debug_printf(DEBUG_INFO, "root is null");

	/* tmp must not be null, have something in it and not equal NOT_FOUND */
	if(tmp&&strlen(tmp)&&strcasecmp(NOT_FOUND,tmp)) {

        /* Hack number 12349108 for lyricwiki, it returns 8859-1, so convert it */
        ret = g_convert_with_fallback(tmp, -1, "ISO-8859-1", "UTF-8", "", NULL , NULL, NULL);
        //ret = g_strdup(tmp); 
		xmlFree(tmp); 
	} else debug_printf(DEBUG_INFO, "content was null");
	
	return ret; 
}
