/* globe - display the currently-lighted face of the Earth in ASCII
**
** Copyright (C) 1994 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <sys/types.h>
#include <stdio.h>
#include <time.h>


#define SECSPERDAY 86400
#define OFFSET 43200

#define NGLOBES 30
#define NLINES 23


static char* globes[NGLOBES][NLINES] =
    {
    "             ._o##HMP'\"\"\"&&Z##o_",
    "          _od'`\"\"' \"\"?\\ HMM9MMMMMHb_",
    "       .dHM'        `9M#HMMMMMMMMMMMMb.",
    "     .d#\"\"'         ooHM#9HMMMMMMMMMMMMb.",
    "    d*'             HMMdbdd+'*HH#MMMMMMMM?",
    "  ./'            ..?MMMMMMM#bd##obMMMMMMMMb",
    "  H              $MMMMMMMMMMMMMMMMM&MMMRMHMH",
    " d6.            |MMMMMMMMMMMMMMMMMMM&HMMM|`9b",
    "|             - {MMMMMMMMMMMMMMMMMMMM&MH''  H|",
    "MMH|            `9MMMMMMMMMMMMMMMMMMMMM#H'  `H",
    "MMMM#.            \"**\"\"'\"#MMMMMMMMMMMMMM|    |",
    "MMMMMb\\                   |MMMMMMMMMMMH'     |",
    "MMMMMMMMHo                `?MMMMMMMMMM       |",
    "MMMMMMMMMH                  MMMMMMMMMb  .    |",
    "|*MMMMMMM.                 |MMMMMMMMM*,H|   .|",
    " \\TMMMMMM'                 `MMMMMMMP',M?.   /",
    " `|9MMMR'                   HMMMMMP' `'    |",
    "  `?9MMM                    `MMMH'        /",
    "    \\MMH                     \"\"         ,/",
    "     `*M\\                             ./'",
    "       `*\\o   ..                    ,+'",
    "          \"-\\,_                 _.-\"",
    "              \"^~-v_o#######d#\"\"",
    "              _o#>MMMM?\"\"`?&##o_.",
    "          _dHH''+\"\"  \"\"-o.+MMMMMMHb_",
    "       .dHMMM'         `9M#MMMMMMMMMMb.",
    "     .dMH*\"\"\"          ,odMH*MMMMMMMMMMb.",
    "    dMP'         --    `HMMdo&/*`#M#MMMMM?",
    "  .dP'                .?MMMMMMM#o##boMMMMMb",
    "  HM|                ?MMMMMMMMMMMMMMMMMMMMM&",
    " d\"Mb_               MMMMMMMMMMMMMMMMMMMHMM|\\",
    "|M    |              MMMMMMMMMMMMMMMMMMM6MH'`|",
    "|MdMH#.              `HMMMMMMMMMMMMMMMMMMMH| |",
    "|`MMMMH#\\              `**\"\"'`#MMMMMMMMMMMM' |",
    "||MMMMMMMo_                    HMMMMMMMMMH'  |",
    "||MMMMMMMMMMHb.                `HMMMMMMMM'   |",
    "|`MMMMMMMMMMMH'                 |MMMMMMMM..  |",
    "| `HMMMMMMMMM                  .MMMMMMMMH,& .|",
    " \\  TMMMMMMMM                  `HMMMMMM',H: /",
    " `| `HMMMMM\"'                   MMMMMH' \"' |",
    "  `\\ /MMMMP                     |MMH\"'    /",
    "    \\.`MMH'                     `\"'     ,/",
    "     `\\:HM.                           ./'",
    "       `~Z#\\v    .                  ,/'",
    "          \"-\\_ \\.               _.-\"",
    "              \"\"b~v\\_od#####=d\"\"",
    "              _odp$MMMHR:\"\"\"##o_",
    "          _d$MMH\" \"*\"  \"\" \\\\+HHMMHb_",
    "       .dHMMMHMR          \"*HHMMMMMMMb.",
    "     .dMMMM*\"'\"'           vdMM#MMMMMMMb.",
    "    dMMMP'            -    |HM6bdd#`HMHMM?",
    "  .dMHP'                 ..|MMMMMMHbd#bMMMb",
    " .H' &b                  :HMMMMMMMMMMMMMMMMH",
    " d[p\"9H\\_.               |MMMMMMMMMMMMMMMMMMb",
    "|`HH     '               |MMMMMMMMMMMMMMMMMMT|",
    "| `boHMH#L               ``MMMMMMMMMMMMMMMMMH|",
    "|   dMMMMMH#\\              ``#\"\"\"\"*HMMMMMMMMM|",
    "|. |MMMMMMMMMo\\                    |MMMMMMMM||",
    "|  |MMMMMMMMMMMMM#\\                `9MMMMMMH |",
    "|   9MMMMMMMMMMMMM?                 |MMMMMM|.|",
    "|    *HMMMMMMMMMM|                 .MMMMMMM\\L|",
    " \\     HMMMMMMMMM'                 `MMMMMP\\P/",
    " `\\    |MMMMMMP\"'                   MMMMP'^7",
    "  `\\    9MMMMM'                    .MMH'  /",
    "    \\.  `MMMH'                      \"   ,/",
    "     `\\. `HM|                         ./'",
    "       `~\\ *H\\,    ..               ,/'",
    "          \"-\\_  ,\\              _.-\"",
    "              \"-+#qo\\_ood###==\"\"",
    "             ._o##M'MMMMH?:'-qo_",
    "          _dH*SMMM\" `\"\"  \"\" \\o&HMHb_",
    "       .dHMMMMMMHML          \"*HMMMMMb.",
    "     .dMMMMMMH*\"'\"'           ,dMM#MMMMb.",
    "    dMMMMMM*'            --    *MMb&d?*MH?",
    "   dMMM#M''                   .|MMMMMHb#bMb.",
    "  HMH' .H\\                   `]MMMMMMMMMMMMH",
    " /|MLd/'9Hb__                 MMMMMMMMMMMMMMb",
    "|  `HM+      '                MMMMMMMMMMMMMMM|",
    "|    |bodMM##?                `9MMMMMMMMMMMMMH",
    "|      |MMMMMMH#b               \"**\"\"\"#MMMMMMM",
    "|   . |MMMMMMMMMMbo_                   MMMMMMM",
    "|     |MMMMMMMMMMMMMMMb,               `MMMMMM",
    "|      ?MMMMMMMMMMMMMMH'                MMMMMH",
    "|       ?HMMMMMMMMMMMM'                JMMMMM|",
    " \\        |MMMMMMMMMMP                 MMMMRP",
    " `|        MMMMMMMR\"\"                  MMMP7",
    "  `\\       9MMMMMH'                   |MH'/",
    "    \\.     |MMMH?                     `',/",
    "     `\\.    TMM'                      ./'",
    "       `~\\   `HL.-    .             ,/'",
    "          \"-\\_  ' ,, .          _.-\"",
    "              \"-~~HHo__,od##==^\"'",
    "              _od#HM[\"MMMM:$--v_.",
    "          ,oHMR'$HMM: `\"'  \"' -HHHb_",
    "       .dHMMMMMMMMM#M?         `*&MMMb.",
    "     .dMMMMMMMMMH\"\"'`\"           ,HMHMMb.",
    "    /MMMMMMMMMP'             -    *H6ddPH?",
    "   /JMMMMM#M''                    .MMMMM#Hb",
    "  | MMM?   H&,                   `HMMMMMMMMH",
    " /  |MM_#|`\"DHb\\_.                HMMMMMMMMMb",
    "|    \"\"HM#.      !                |MMMMMMMMMM|",
    "|       `HoodMMH##_               `*MMMMMMMMMH",
    "|         `|MMMMMMMH#o              `**\"'*MMMM",
    "|      .  |MMMMMMMMMMMbo.                 dMMM",
    "|         &MMMMMMMMMMMMMMMMb.             |MMM",
    "|          9MMMMMMMMMMMMMMMH'             |MMH",
    "|           *HMMMMMMMMMMMMT               HMM|",
    " \\            TMMMMMMMMMMM'              |MMP",
    " `|           `MMMMMMMM'\"'               dMH",
    "  `\\           MMMMMMH'                 ,MP",
    "    \\.         MMMM#'                   i/",
    "     `\\.       TMM?                   ./'",
    "       `~\\     `*M?,-    _          ,/'",
    "          \"-\\_    ` ,, .        _.-\"",
    "              \"-\\=vHMb__ooo#==-\"",
    "              _od#HMM6&*MMMH::-_",
    "          _dHMMMR??MMM? \"\"| `\"'-?Hb_",
    "       .~HMMMMMMMMHMMM#M?        `*HMb.",
    "     ./?HMMMMMMMMMMM\"*\"\"\"           &MHb.",
    "    /'|MMMMMMMMMMM'             -   `*MHM\\",
    "   /  |MMMMMMHHM''                   .MMMHb",
    "  |   9HMMP   .Hq,                   TMMMMMH",
    " /     |MM\\,H-\"\"&&6\\__               `MMMMMMb",
    "|       `\"\"HH#,       \\             - MMMMMMM|",
    "|           `HoodHMM###.              `9MMMMMH",
    "|              .MMMMMMMM##\\             `*\"?HM",
    "|         ..  ,HMMMMMMMMMMMo\\.              |M",
    "|             |MMMMMMMMMMMMMMMMHo           |M",
    "|              ?MMMMMMMMMMMMMMMM*           |H",
    "|.              `#MMMMMMMMMMMMM'           .M|",
    " \\                `MMMMMMMMMMM*            |P",
    " `\\                MMMMMMMMT\"'            ,H",
    "  `\\              `MMMMMMH?              ./",
    "    \\.            |MMMH#\"               ,/",
    "     `\\.          |MMP'               ./'",
    "       `~\\        `HM:.-    .       ,/'",
    "          \"-\\_       '_\\ .      _.-\"",
    "              \"-\\-#odMM\\_,oo==-\"",
    "              _od#HMMMMM&HMM#~o_.",
    "          _vHMMMMMM$`9MMb_\"\"' \"'`\\b_",
    "       .~'|MMMMMMMMMMMMMMHM\\.     `\"#b.",
    "     ./' ,MMMMMMMMMMMMMP*\"'\"'        `Mb.",
    "    /'  |MMMMMMMMMMMMM'             - `*M?",
    "   /     MMMMMMMM#HM'                   9Mb",
    "  |      99MMM'    9\\\\                 `TMMH",
    " /         HMM\\,#|\"\"?pMb__.             |MMMb",
    "|           \"\"\"#M#+       `|           - MMMM|",
    "|                ?\\oodHMH##L.            `HMMH",
    "|                  `|MMMMMMMM#b,          `*\"H",
    "|              -   |MMMMMMMMMMMMo_           |",
    "|                  &MMMMMMMMMMMMMMMHo        |",
    "b                   9MMMMMMMMMMMMMMM*        |",
    "|,                   *HMMMMMMMMMMMM?        .|",
    " \\                     TMMMMMMMMMM?         /",
    " `|  -                 dMMMMMMMP\"'         /'",
    "  `\\                   MMMMMMH'           /'",
    "    \\.                |MMMH#\"           ,/",
    "     `\\.              MMH'            ./'",
    "       `~\\            HM:..   .     ,/'",
    "          \"-\\_          .\\      _.-\"",
    "              \"-\\-odbo#ML_oo-=-\"",
    "             ._od#HMMMMHMR&M##-_",
    "          _/dMMMMMMMM[:$MMb\\:\"|\"\"^~_",
    "       .~'' |MMMMMMMMMMHMMMMH&\\    `\"\\.",
    "     ./'   .HMMMMMMMMMMMMMMP*'\"'      \"\\.",
    "    /'     |MMMMMMMMMMMMMM'             *?",
    "   /        HMMMMMMMMHHM?                !b",
    "  |         `6HMMM|    T|+.              `9H",
    " /|          ` HMM?_dH`\"\"&$bo__           `Mb",
    "|               ``\"*HH#|       \\           TM|",
    "|                    `*bo\\#MMH##_          `HH",
    "}                       ']MMMMMMMH#\\        `H",
    "|                   .   dMMMMMMMMMMMo\\       |",
    "|                       MMMMMMMMMMMMMMMH,    |",
    "|                       `HMMMMMMMMMMMMMH'    |",
    "|                        `*MMMMMMMMMMMM'    .|",
    " \\                          MMMMMMMMMM'     /",
    " `|                        |MMMMMMM?\"'     |",
    "  `\\                       MMMMMMH'       /",
    "    \\.                    HMMM#?'       ,/",
    "     `\\.                 ?MM*'        ./'",
    "       `~\\               MM?..  .   ,/'",
    "          \"-\\_            _o.   _.-\"",
    "              \"-\\-vod#od#M:o-~-\"",
    "             ._od#dHMMMMMMM9##o_",
    "          _\\H#*MMMMMMMMM??9Mbd$\"\"`._",
    "       .~^\"   `HMMMMMMMMMMMMMMMHb.  `\\.",
    "     ./'      ,HMMMMMMMMMMMMMMP\"'\"    `\\.",
    "    /'        |MMMMMMMMMMMMMMT         -`\\",
    "   /           `MMMMMMMMMHHH?             \\",
    "  |.            `H*MMMP    !Pq\\           `\\",
    " / `|              *MMH_,#|\"\"?&6o_.        `b",
    "|                    \"\"\"#M##       \\        +|",
    "|                         `#oooHMH##\\        \\",
    "| .                          'MMMMMMMH#,     |",
    "|                       ..   HMMMMMMMMM6\\.   |",
    "P                           |MMMMMMMMMMMMMH, |",
    "| .                          |MMMMMMMMMMMMH' |",
    "|!                            `HMMMMMMMMMH  .|",
    " \\   '                          MMMMMMMMH'  /",
    " `|                            ,MMMMMMP\"   |",
    "  `\\                          .MMMMMH'    /",
    "    \\.                       ,HMM#*\"    ,/",
    "     `\\.                    .MM*'     ./'",
    "       `~\\                  MR\"-  _ ,/'",
    "          \"-\\_              _o.._.-\"",
    "              \"-\\-vooo#oo#HS-~-\"",
    "              _od#d&&MMMMMMM##o_.",
    "          _~?MH**MMMMMMMMM$$*Mb&P+._",
    "       .~^-\"'    \"MMMMMMMMMMMMMMMM\\_`\\.",
    "     ./'          HMMMMMMMMMMMMMMR*\"  `\\.",
    "    /'            9MMMMMMMMMMMMMM.      `\\",
    "   /               `HMMMMMMMMH#M:         \\",
    "  |  .              `*&MMMM    `Hq,        |",
    " /    \\.              '`HMM?_dH`\"`H6o_.     \\",
    "|                        ``\"\"HH#|     `|    `|",
    "|                              ?\\ooHMH##.    |",
    "|                                 |MMMMMM#,  |",
    "|                            .   |MMMMMMMMb\\ |",
    "|-'                              &MMMMMMMMMMH|",
    "|   .                            `HMMMMMMMMMH|",
    "|_`                               `HMMMMMMMM.|",
    " \\                                  MMMMMMM'/",
    " `|                                JMMMMM''|",
    "  `\\                              ?MMMM*' /",
    "    *b                           dMM#'' ,/",
    "     `\\.                       .HH*'  ./'",
    "       `~\\                    |MP: .,/'",
    "          \"-\\_               .,:_.-\"",
    "              \"-~-_oooodbod##:-\"",
    "              _od>d&&&HMMMMM##o_.",
    "          _~/\"TMH**HMMMMMMMM$$&MHk~_",
    "       .~''-`\"'    `*HMMMMMMMMMMMMMHZ>.",
    "     ./'             |MMMMMMMMMMMMMMP'`\\.",
    "    /'               `HMMMMMMMMMMMMM.   `\\",
    "   /                   `HMMMMMMMMHH[      \\",
    "  |                     `*RHMMM    `Db     |",
    " /       `|                 *MMb_?#\"\"\\Mo_.  \\",
    "|                             \"\"\"#M#|    `. `|",
    "|                                  `\\odHM#b  |",
    "|                                     TMMMMH||",
    "|  -                              .  |MMMMMMMd",
    "|   -                                {MMMMMMMM",
    "H    -                               `MMMMMMMH",
    "|. . '                                |MMMMMM|",
    " \\\\`        '                          dMMMMP",
    " `|                                   ?MMMH7",
    "  `\\                                 ?MMM*/",
    "    \\:\\,                           .dMH*\\/",
    "     `\\H.-                        ,M*'./'",
    "       `~\\                      .H*:,/'",
    "          \"-\\_                 _\\,-\"",
    "              \"-\\-\\,ooooo#oo=d\"\"",
    "              _o#>?&&&&HMMMM##o_",
    "          _od*\"\"TMH*\"#MMMMMMMM$&HHb_",
    "       .//\"'--`\"\"     `\"HMMMMMMMMMMMMb.",
    "     ./'                 MMMMMMMMMMMMMT\\.",
    "    /'                   `HMMMMMMMMMMM? `\\",
    "   /                       `HMMMMMMMM#L   \\",
    "  |                          `HHMMM   `H\\  |",
    " /          ``|                 ?HMb_#|'9b\\.\\",
    "|'                                ``\"#Hb   `:|",
    "|                                      *bdMHL|",
    "|                                        |MMMH",
    "|     -                               .  MMMMM",
    "H,      '                               |MMMMM",
    "M`|     -                                MMMMH",
    "|. ,  . `       .                        |MMM|",
    " \\.., '                                  ,MMP",
    " `&,                                    .HMH'",
    "  `9,                                  ,MMP",
    "    *, `\\,                            ?MH?",
    "     `\\.|| -                        ,&&>'",
    "       `~\\                        ,&6>'",
    "          \"-\\_                 ._v~\"",
    "              \"^~-v_,ooooodb~=\"\"",
    "              _od#d?&&&&&MMM##o_.",
    "          _vH##\"\"\"?MM#\"*HMMMMMMMZ&b_",
    "       .d/>'\"  - '\"'     `\"HMMMMMMMMMb.",
    "     .d*'                   TMMMMMMMMMM+.",
    "    d*'                      *MMMMMMMMMM/\\",
    "   /'                          `HMMMMMMHb \\",
    "  |                              `HMMM| `\\\\|",
    " /               `~                 *MH\\#P*b\\",
    "| '                                   \"\"*H| `|",
    "|                                        `9oMH",
    "|                                          `MM",
    "L                                        - |MM",
    "Mb?.       -'                              &MM",
    "[P|\"\\       -   .                          |MH",
    "|M,   .  _  `                              |M|",
    " 9H\\  \\  \"                                 |P",
    " `HMb                                     ,H",
    "  `9Mb                                  .?P",
    "    *H|   \\b                           .H?",
    "     `<!  |R                         .d*'",
    "       `~\\                         .d*'",
    "          \"-\\_                  _,-\"",
    "             `\"\"\\=v\\_,oooood~~-\"'",
    "              _od#&&$?&&&&MM##o_.",
    "          _odMM#\"\"'\"\"9MM*\"#MMMMMMHb\\",
    "       .dH*:/'\"- -- \"\"      `*HMMMMMMb.",
    "     ./M#^'                    ?MMMMMMMb.",
    "    dMp'                        `HMMMMMMM?",
    "  ./'\"                            `*MMMMMMb",
    " ./-                                `HMMM `&",
    " /                   `-|               ?Mb?Pb",
    "|'  '                                    `\"&||",
    "M                                           \\M",
    "T                                            T",
    "Mo.           -                            . M",
    "T9Mb?\\.        -`                            M",
    "P_?P? \"\\        -                            H",
    "|MbH,    .   _  `                           ||",
    " 9MMH\\   v.  '                              /",
    " `HMMMH.                                   /'",
    "  `9MMMH                                 ./'",
    "    \\:*H|    `b,                        ,/",
    "     `\\.`    dT                       ./'",
    "       `~\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "             `\"\"*bqb__,ooooo~=-\"",
    "              _od#M&&&?$&&HM##o_.",
    "          _oHH#MM#\"\"'\"\"*MMP\"#HMMMHb_",
    "       .dHMM? ~\"''  ---\"'     `\"#MMMMb.",
    "     .dM#M#^'                    `*MMMMb.",
    "    dMM?&'                         `HMMMM?",
    "  .dP|'\"                             \"*MMMb.",
    "  HT-                                  `HMb\\",
    " /:                       `~             `HHb",
    "|||                                        `*|",
    "PH|                                          \\",
    "M\"'`                                         |",
    "M&\\o_ .                                      {",
    "R+\"9HMbv+\\           `                       |",
    "T*'_:9`b ``\\             .                   |",
    "| dMbJH.     ,   ..  ^                      .|",
    " \\MMMMMH\\    \\   `  .                       /",
    " `HMMMMMMH.                                |",
    "  `9MHHMMMH                               /",
    "    *. `*#H     `&o                     ,/",
    "     `\\.  `'    dP'                   ./'",
    "       `~\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "             `\"\"*#&#b__,oooo-~-\"",
    "              _od#HM6&&$?&&M##o_",
    "          _oHMM##HMH*\"\"\"\"`HMM\"#HMHb_",
    "       .dHMMMM* .*'` - - `\"'    `\"*MMb.",
    "     .dMMM#&H*^'                    ?MMb.",
    "    dMM&M:d/'                        `*MM?",
    "  .dMM| '\"                             `*Mb.",
    "  HMMT-                                  `HH",
    " dH\":                         \"~.          ?b",
    "|M ||     .                                 `|",
    "M?.4[                                        |",
    "M,H''                                        |",
    "MMMp]ov_.               -                    |",
    "H$\"b\":99MHo++\\           -                   |",
    "|\"`\"*._:`T`=  \"b          -                  |",
    "|   ?HMb_M?      .,   _  `-                 .|",
    " \\ ,MMMMMMMb_    v.   '                     /",
    " `|`MMMMMMMMMb                         -   |",
    "  `\\`HMH#MMMMM                            /",
    "    \\:'  `\"###      `#v                 ,/",
    "     `\\.     \"     o&'                ./'",
    "       `~\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "             `\"\"*#HH##__,ooo-~-\"",
    "              _od#HHM6&&&?$&##o_",
    "          _oHMMMMH##RM#\"\"\"\"`#MM\"#Hb_",
    "       .dHMMMMMMH' .*\"` - - `'    `\"Hb.",
    "     .dMMMMMH#$&+-\"                  `9b.",
    "    dMMMM#][_d&'                       `H?",
    "  .dMMMMH |'\"`                           `\\",
    "  HMMMMM'-                                `\\.",
    " /MMH\"::                          \"~.       \\",
    "|?MM  Hi      `                             `|",
    "|T?' ||M                                     |",
    "|H|.d}`'  '                                  |",
    "|9LMM&p!|o,_. .              -               |",
    "|`H??|\\`\":PHMHovd\\_            '             |",
    "|  \"\"\"?* :_:`T`b. `?\\             .          |",
    "|      ?#MML.M?       ,   ..  `             .|",
    " \\   .dMMMMMMMM#.    .\\   `                 /",
    " `|  `HMMMMMMMMMMb                         |",
    "  `\\  `9MM##MMMMMM                        /",
    "    \\.  \"   `\"##H|      :b,             ,/",
    "     `\\.        `'    ,d*'            ./'",
    "       `~\\                          ,/'",
    "          \"-\\_ .                _.-\"",
    "              \"\"*#HMM##:_,oo---\"",
    "             ._o##HM&M6&&&$?##o_.",
    "          _oHMMMMMMH##H9M*\"'\"`#HMb\\_",
    "       .dHMMMMMMMMMM  :\"'' - - \"   `\"\\.",
    "     .dMMMMMMMMH#\"&b-\"                `\\.",
    "    dMMMMMMM#TM_,#?                     `\\",
    "  .dMMMMMMMM  \"''                         \\.",
    " .HMMMMMMMM: -                      .      |",
    " dHTMMMH\"':                          `^|    \\",
    "|P `MMH  |6.                                `|",
    "M'`|P#' ,|M6                                 |",
    "T  &H .dM-\"'                                 |",
    "|  9M.MMH#r?|ov\\_                -           |",
    "|   `6:$'#|`\"\"?*MMHov*,.          -'         |",
    "|     \"\"`*?\" __:\"9\"*=  \"\"|         -         |",
    "|         .d#MM6_MH.       |   _  `-        .|",
    " \\      .oHMMMMMMMMH\\     v.   '            /",
    " `|     `MMMMMMMMMMMMH.                    |",
    "  `\\     `MMM##HMMMMMM'                   /",
    "    \\,    `'    \"\"###'      Tb          ,/",
    "     `\\.           `\"     o/' -       ./'",
    "       `~\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "              \"\"*#HMMMMHc_,o---\"",
    "              _o##HMM&MM&&&&:#o_",
    "          _oHMMMMMMMMM###&MP\"'\"*#H+_",
    "       .dHMMMMMMMMMMMMM  :*  - --'  `\\.",
    "     .dMMMMMMMMMMMM#*\\H~'             `\\.",
    "    dMMMMMMMMMMH?ML_oH'                 `\\",
    "  .dMMMMMMMMMMM}  *\"'                     \\",
    " .HMMMMMMMMMMMH: -                     .   |",
    " /MMH\"MMMHM?\" :                         `~. \\",
    "|'M'  9MMM|  -M,       `                    `|",
    "|.M   |i**' .~TM.                            |",
    "| \"  |&M  .dM| \"'  '                         |",
    "|     9ML|MMH>p'*,o._.  .            -       |",
    "|      `H???'#\\ \"\"`P9MM#vv+\\.         -'     |",
    "|        `\"\"`\"\"*'.__``&\"*~  \"b.       -  .   |",
    "|             .d#HMM\\_Mb       .   _  `    ..|",
    " \\          ,oHMMMMMMMMM#.    ..   '        /",
    " `|         9MMMMMMMMMMMMM|                |",
    "  `\\         9MMH##HMMMMMM'               /",
    "    \\.        \"     `?#H#'     .H.      ,/",
    "     `\\.               \"'    ,p''-    ./'",
    "       `\\\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "             `\"\"*#HMMMMMM#:o---\"",
    "             ._od#HMMM6HM&&&#>o_",
    "          _oHMMMMMMMMMMMH##*MM\"\"`b\\_",
    "       .dHMMMMMMMMMMMMMMMH. ?'  - ^ `\\.",
    "     .dMMMMMMMMMMMMMMMH#'db-'         `\\.",
    "    dMMMMMMMMMMMMMMH`M\\_oM'             `\\",
    "  .dMMMMMMMMMMMMMMM|  \"\"'                 \\",
    "  H#MMMMMMMMMMMMMMHi -                   . |",
    " d? MMM*\"HMMMPM?\"':.                      `\\\\",
    "|'  MP' .`9MMM|   4b        '               `|",
    "H   M|  ` d`**'  /'Hb                        |",
    "|   `'   q/H  .,HD \"'                        |",
    "|        `&ML:MMM$cr!P,ov_.              -   |",
    "|          `H$:?'`*|`\":9\"HMMbv/\\\\         '  |",
    "L            `\"\"\"\"\"?\" :__\"`T`b| `?|          /",
    "|,                 _d#MM6_JH,      |  .. -  ,|",
    " \\.             _odMMMMMMMMMH\\    ,.  `     /",
    " `|             HMMMMMMMMMMMMM|            |",
    "  `\\             MMMH##HMMMMMM'           /",
    "    \\.  .        `\"     `*#H*'     M.   ,/",
    "     `\\.                  `\"    ,~''  ./'",
    "       `~:                          ,/'",
    "          \"-\\_                  _.-\"",
    "              \"^*#HMMMMMMM#&---\"",
    "             ._od#HMMMMMHM6&##o_",
    "          _dHMMMMMMMMMMMMMMH##9R'^~_",
    "       .dHMMMMMMMMMMMMMMMMMMH,`*   `\"\\.",
    "     .dMMMMMMMMMMMMMMMMMMM#*iD~'      `\\.",
    "    dMMMMMMMMMMMMMMMMMM#`M\\,dH          `\\",
    "  .dMMMMMMMMMMMMMMMMMMMH  *\"'             \\",
    "  HMH#MMMMMMMMMMMMMMMMHb -                 $",
    " dMM' $MMMH'`HMMMM\\H\"' :                    \\",
    "|M?'  `MM'  .`TMMMH   -M\\       `           `|",
    "MM'    Mb   ` |i`#'  ./!ML                   |",
    "M|      \"    ?bM|  .oHr``'  `                |",
    "H             $MM_|MMM\\#/ |o\\\\_            - |",
    "|              `*6??:'|*|`\":9\"MMHov+\\       '|",
    "H.                \"\"\"`\"'*' __.\"9\"*~ `\"|      ?",
    "|H|                    .,##MML_Mb      | . `.|",
    " 9b.                .,oHMMMMMMMMM?    \\  `  /",
    " `&                 |MMMMMMMMMMMMM|        |",
    "  `\\                 9MMH##HMMMMMH'       /",
    "    \\.    .          `\"     `###'    ,| ,/",
    "     `\\.                      \"'  ,/^'./'",
    "       `~\\                          ,/'",
    "          \"-\\_                  _.-\"",
    "              \"\"\\dHMMMMMMMMM=:-\"",
    "              _od#HMMMMMMMMM##o_.",
    "          _dHMMMMMMMMMMMMMMMMH##M}~_",
    "       .dHMMMMMMMMMMMMMMMMMMMMMb`9' `\\.",
    "     .dMMMMMMMMMMMMMMMMMMMMMMH#`H/    `\\.",
    "    dMMMMMMMMMMMMMMMMMMMMMM?9H.,M,      `\\",
    "  .dHMMMMMMMMMMMMMMMMMMMMMMH  *\"'         \\",
    "  HMMMM##MMMMMMMMMMMMMMMMMMS. -            |.",
    " dMMMM*' `MMMMH'\"HMMMMPH?\" :.               \\",
    "|MMH*'    9MP\"   /'MMMM|   |b.      .       `|",
    "MMMH`     `Hb      M`**'  ,~TM,              |",
    "MMM|        \"     #/H,  _dM~``'  '           |",
    "MM'               `&ML.4MMH\\#$|\\ov_.         4",
    "MM                  `*6:??'?* \"\":PHMHo/\\.    |",
    "MM,.                  `\"\"\"`\"'*'.:_\"??*| `|   |",
    "|M|d|                       .d#HM6.Mb     ,..|",
    " 9LT|.|                  _odMMMMMMMMM,   , `/",
    " `H/\"                    MMMMMMMMMMMMM     |",
    "  `\\.                    9MMH##HMMMMH'    /",
    "    \\.       .           `'    `*##*   ?\\/",
    "     `\\.                         \"' ,/?/'",
    "       `~\\   `                      ,~'",
    "          \"-\\_                  _.-\"",
    "              \"\"*#&MMMMMMMMM#b-\"",
    "             ._o<>HMMMMMMMMM##o_.",
    "          _oHMMMMMMMMMMMMMMMMMMM#&b_",
    "       .dHMMMMMMMMMMMMMMMMMMMMMMMb?\\`\\.",
    "     .dMMMMMMMMMMMMMMMMMMMMMMMMMM*Tp' `\\.",
    "    /HMMMMMMMMMMMMMMMMMMMMMMMMM>&,,M,   `\\",
    "  .dH#MMMMMMMMMMMMMMMMMMMMMMMMMH `?'      \\",
    "  HMMMMM[MH##MMMMMMMMMMMMMMMMMM&,-'        |",
    " dMMPMMMMH'  `MMMMH*\"?MMMMM\\H\"'`:           \\",
    "|MMM6MH$'     TMM'   .`TMMMH,   M\\     `    `|",
    "MMMMMHH`      `HH.   ` .L`#*'  /'ML          |",
    "MMMMMM'         `'    -#dH   _dH \"'  '       |",
    "MMMMP'                 `9ML.HMMP#p!|oo_      |",
    "MMMM                     `#6:?`'*|`\":PHMbd\\. |",
    "MMMM| .                    `\"\"\"\"\"*'.:_\"P`|`\\ |",
    "|MMMH,M.                        .?#HM6,M   .\\|",
    " 9MM|`M| -                   .odHMMMMMMM|  ,/",
    " `HMM `'                     HMMMMMMMMMM|  |",
    "  `9M,                       JMMH##MMMM*' /",
    "    *.           .           \"'    *H#' ,?",
    "     `\\.                           -'.o/'",
    "       `~\\      '                   ,/'",
    "          \"-\\_                  _.-\"",
    "              \"^*#HHHMMMMMMM##-\"",
    "              _od:&HMMMMMMMM##o_",
    "          _dHMMMMMMMMMMMMMMMMMMMMD\\_",
    "       .dHMMMMMMMMMMMMMMMMMMMMMMMMM&&~.",
    "     .dMMMMMMMMMMMMMMMMMMMMMMMMMMMMH*H`\\.",
    "    dH9HMMMMMMMMMMMMMMMMMMMMMMMMMM*&,J? `\\",
    "  .dM#bbHMMMMMMMMMMMMMMMMMMMMMMMMMM|`?'   \\",
    "  HMMMMMMMMH]M###MMMMMMMMMMMMMMMMMMb -     |",
    " dMMMMMPMMMMM*'  `9MMMMH'\"9MMMMTM\"'`_       \\",
    "|MMMMMMbMM*?'     `MMP'    'HMMMb   M,      `|",
    "MMMMMMMMH#P`       `Mb    ' ||`#'  .^M,      |",
    "MMMMMMMMMP           `'    |b]b  .dH-\"' `    |",
    "MMMMMMMH'                   !MM_|MMH>p\"\\o\\   |",
    "TMMMMMM                       *M???'#|\":T9M+\\|",
    "|TMMMMM|  .                     \"\"\"\"\"*'__\"?*`#",
    "||MMMMMD.dH                         .d#MMJ| .|",
    " \\9MMMM `MP ..                   .odHMMMMM| /",
    " `|*MMM! `'                      MMMMMMMMM||",
    "  `\\`MM|                         MMH#HMMM*/",
    "    \\:'                          \"   `#*\\/",
    "     `\\.                             -?/'",
    "       `~\\         '                ,/'",
    "          \"-\\_                  _.-\"",
    "              \"-+#HMM#MMMMMM##\"\"",
    "             ._od#/$HMMMMMMM##o_",
    "          _oHMMMMMMMMMMMMMMMMMMMMHb_",
    "       .dHMMMMMMMMMMMMMMMMMMMMMMMMMMMb.",
    "     .dMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM9+.",
    "    dM&+9HHMMMMMMMMMMMMMMMMMMMMMMMMMM*b]/\\",
    "  .dMMHd#o#MMMMHMMMMMMMMMMMMMMMMMMMMMH,?' \\",
    " .HMMMMMMMPMMMMM]MH##MMMMMMMMMMMMMMMMMb,-  |",
    " dMMMMMMMMM9MMMMMH'  `\"MMMMM*\"?MMMMPH\" :    \\",
    "|MMMMMMMMMMbMM*\"\"      ?MMT'   `?MMM?  9\\   \"|",
    "MMMMMMMMMMMMH#H`'       ?HL      6`#'  /9L   |",
    "P\"HMMMMMMMMMMH'           \"     q/H  .dD'' ' |",
    "| HMMMMMMMMH\"                   `9ML:MMR#?\\o.|",
    "| `MMMMMMMM                       `H$??`#`:MMH",
    "|  TMMMMMMM,  .                     \"\"\"\"*'_:P#",
    "|  |MMMMMMM|,dH                         ?#MHL|",
    " \\  9MMMMMi |M| ..                   ,dHMMMMP",
    " `|  9MMMM' `\"'                     |MMMMMMH",
    "  `\\  `HMM'                         JMH#MMP",
    "    \\_ `\"               .           \"  |H?",
    "     `\\.                              ./'",
    "       `~\\            '             ,/'",
    "          \"-\\_                  _.-\"",
    "              \"-==&MMMM#MMMM##\"\"",
    "             ._-c>&R?$MMMMMM##o_",
    "          _o$MHMMMMMMMMMMMMMMMMMMHb_",
    "       .~1MMMMMMMMMMMMMMMMMMMMMMMMMMMb.",
    "     .<bdMM9MMMMMMMMMMMMMMMMMMMMMMMMMMMb.",
    "    /\\M6b>^9R#MMMMMMMMMMMMMMMMMMMMMMMMMDM?",
    "   /dMMMMb##b#dMMMMHMMMMMMMMMMMMMMMMMMMMb*\\",
    "  bMMMMMMMMMMM&MMMMM$MM##HMMMMMMMMMMMMMMM\\-\\",
    " dMMMMMMMMMMMMM*MMMMMM*   `9MMMM#\"?MMMMH\"`. \\",
    "|HMMMMMMMMMMMMMbMMH\"?       9MM'   ??MMH  \\.`|",
    "|MMMMMMMMMMMMMMMH##|`       `HH,   ' b`*' /M |",
    "|*\"'#MMMMMMMMMMMMM*           `'    ?/H  ?D` |",
    "|    MMMMMMMMMMM?'                   *M?4MM#bd",
    "|    ?MMMMMMMMM'                      ?M???|:M",
    "|     9MMMMMMMM|  .                     \"\"\"*_H",
    "|     &MMMMMMMM}.oH|                      ,#M|",
    " \\    `HMMMMMM: iMM  ..                 ,dMMP",
    " `|    `HMMMMM' `\"'                    |MMMH",
    "  `\\     *MMM|                        .MHHP",
    "    \\.    `\"                          `',?",
    "     `\\.                              ./'",
    "       `~\\               `          ,/'",
    "          \"-\\_                  _.-\"",
    "              \"-~=q#HMMMHHMM##\"\"",
    "              _v~:S&M$?HMHMM##o_",
    "          _.:$\\#MMMMMMMMMMMMMMMMMHb_",
    "       .~'.HMHMMMMMMMMMMMMMMMMMMMMMMMb.",
    "     ./',odHMMMMMMMMMMMMMMMMMMMMMMMMMMMb.",
    "    /\" |M6&d\\\"?M&#MMMMMMMMMMMMMMMMMMMMMMM?",
    "   / _HMMMMMbd##obHMMMMMMMMMMMMMMMMMMMMMMM}",
    "  | dMMMMMMMMMMMMMPMMMMH[9M###MMMMMMMMMMMMMH",
    " / dMMMMMMMMMMMMMMM/HMMMMMH'  `\"MMMM*\"HMMMT:\\",
    "| |MMMMMMMMMMMMMMMMMdMM#\":      ?MM'  .\"MMb`6|",
    "| |MMMMMMMMMMMMMMMMMMH#H|'       ?H\\  ` |?* &H",
    "|  ?*\"\"*HMMMMMMMMMMMMMH'           \"    bH .H9",
    "|       {MMMMMMMMMMMH'                  `MLMMM",
    "|       `9MMMMMMMMMR                     `6?*H",
    "L        `MMMMMMMMMH.  .                  `\"\"&",
    "|.       |MMMMMMMMMM|,dM                    ?|",
    " \\        *MMMMMMMT  dM| ..               ,dP",
    " `|        TMMMMMM'  `\"                  ,MH",
    "  `\\        `MMMH'                      .HP",
    "    \\.       `\"                         i/",
    "     `\\.                              ./'",
    "       `~\\                          ,/'",
    "          \"-\\_                . _.-\"",
    "              \"-~=q###MMMMHM##\"\"'",
    "              _o~~^?&M&?]MHM##o_",
    "          _~^\"$?.#MMMMMMMMMMMMMMMHb_",
    "       .~'  :MM#MMMMMMMMMMMMMMMMMMMMMb.",
    "     ./'  .ooMHHMMMMMMMMMMMMMMMMMMMMMMMb.",
    "    /'-   MM6bd>/\"#&#HMMMMMMMMMMMMMMMMMMM?",
    "   /    ?MMMMMMHbd##o#HMMMMHMMMMMMMMMMMMMMb",
    "  |   ?MMMMMMMMMMMMMMM69MMMM69MH##MMMMMMMMMH.",
    " /   |MMMMMMMMMMMMMMMMML*MMMMMM?  `\"MMMH`HMM\\",
    "|    HMMMMMMMMMMMMMMMMMMHHMH*''     ?MM' !9M||",
    "|    9MMMMMMMMMMMMMMMMMMMM##H`'      ?M, ` R?\\",
    "|     `*\"\"\"#MMMMMMMMMMMMMMMH'         `'  |d|d",
    "|           |MMMMMMMMMMMMH'                9LM",
    "M,          `9MMMMMMMMMMT                  `M]",
    "M|            MMMMMMMMMMb   .               `*",
    "|b           |MMMMMMMMMMH oH|               .|",
    " 9,           *MMMMMMMM' ,MH  -            ./",
    " `|            9MMMMMM\"  `\"'              .&",
    "  `\\            ?MMMH'                   ./",
    "    \\.           \"'                     ,/",
    "     `\\.                              ./'",
    "       `~\\.                    '    ,/'",
    "          \"\\\\_                 ._.-\"",
    "              \"-\\~q###HHMMMMd#\"\"'",
    "              _odp^'\"?M&&?MH##o_",
    "          _~^''`$+ #MM9MMMMMMMMMMHb_",
    "       ./'     9MHHMMMMMMMMMMMMMMMMMMb.",
    "     ./\"     ,ooM#MHMHMMMMMMMMMMMMMMMMMb.",
    "    /'  --   MMM&o&~*`#&#HMMMMMMMMMMMMMMM?",
    "   /     . ,HMMMMMM#bd##o#dMMMMHMMMMMMMMMMb",
    "  |      ?MMMMMMMMMMMMMMMMMHMMMMM9MH#HMMMMMH",
    " /      |MMMMMMMMMMMMMMMMMMM/HMMMMM|  \"HMM?Hb",
    "|'      dMMMMMMMMMMMMMMMMMMMM&MM#\":    `MR !H|",
    "T       `MMMMMMMMMMMMMMMMMMMMMH#H|'     `M,`|H",
    "H        `**\"\"\"?HMMMMMMMMMMMMMMM*        `' |M",
    "M\\               MMMMMMMMMMMMM*'             M",
    "MMH,             `MMMMMMMMMMM!               T",
    "MMM|              |MMMMMMMMMM|  .            |",
    "|MM|              HMMMMMMMMMM|,dM           .|",
    " 9ML              `MMMMMMMMT  dM' .         /",
    " `H|               |MMMMMMP'  \"'           |",
    "  `9,               ?MMMH'                /",
    "    \\,               \"'                 ,/",
    "     `\\.                              ./'",
    "       `~\\ .                     `  ,/'",
    "          \"-\\_                  _.-\"",
    "             `\"-~-?######HMM##\"\"'",
    "             ._o##H\"?\"\"S&&?9##o_",
    "          _/^*'\" \":d.|MMPMMMMMMMMHb_",
    "       .d/'      -9MHHMMMMMMMMMMMMMMMb.",
    "     .~'\"       ,ooMHHHMMMMMMMMMMMMMMMMb.",
    "    /'     -    |MMbbdb~'`&M#HMMMMMMMMMMM?",
    "   /         ..?MMMMMMM#bd##b#dMMMMHMMMMMMb",
    " .|         .]MMMMMMMMMMMMMMMMMMMMMMRMH#MMMH",
    " d          |MMMMMMMMMMMMMMMMMMM&HMMMMH `*MM\\",
    "|?          HMMMMMMMMMMMMMMMMMMMMbMM#':   TM`|",
    "M|          `MMMMMMMMMMMMMMMMMMMMMM#H|     9,\\",
    "MM|          `\"#\"\"\"\"*HMMMMMMMMMMMMMMP       '|",
    "MMM\\                 |MMMMMMMMMMMMH'         |",
    "MMMMMb,               `MMMMMMMMMMR           |",
    "MMMMMM'                9MMMMMMMMMM  .        |",
    "|MMMMM                ,MMMMMMMMMMH.dM       .|",
    " 9MMMM                `9MMMMMMMR' dM'..     /",
    " `HMM:                 `MMMMMMP'  \"'       |",
    "  `9ML                  `MMMH'            /",
    "    *M.                  \"'             ,/",
    "     `\\\\                              ./'",
    "       `\\v. .                      `,/'",
    "          \"-v_                  _.-\"",
    "              \"-~-\\o#######M##\"\"'"
    };


int
main( int argc, char* argv )
    {
    time_t now;
    int gnum, lnum;

    now = time( (time_t*) 0 );

    gnum = ( now + OFFSET ) % SECSPERDAY / ( SECSPERDAY / NGLOBES );
    for ( lnum = 0; lnum < NLINES; ++lnum )
	puts( globes[gnum][lnum] );

    exit( 0 );
   }
