/*  Glimmer - settings.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _SETTINGS_H_
#define _SETTINGS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"

struct preferences {
    // General/UI
    gboolean full_filenames_title;
    gboolean full_filenames;
    gboolean async_xfer;
    gboolean close_all;
    gboolean untitled;
    gboolean show_dots;
    gboolean show_details;
    gboolean draw_numbers;
    gboolean draw_pixmaps;
    gboolean cursor_blink;
    gboolean full_selection;
    gboolean copy_sym_on_write;
    // Style For Toolbars
    gint toolbar_style;
    // Notebook Tab Position
    gint notebook_tab_position;
    // Directory Settings
    gchar default_dir[256];
    gchar projects_dir[256];
    gchar terminal[256];
    gchar make[256];
    // History Settings
    gboolean save_toolbars;
    gboolean save_session;
    gboolean open_session;
    gboolean auto_save;
    gint history;
    gint undo_max;
    // User settings
    gchar name[256];
    gchar email[256];
    // File Settings
    gboolean bracketmatch;
    gboolean select_line;
    gboolean syntax;
    gboolean auto_indent;
    gboolean use_spaces;
    gboolean tab_stops;
    guint spaces;
    // Window Settings
    gint geometry;
    gint x;
    gint y;
    gint w;
    gint h;
    gchar print_font[128];
    gint print_landscape;
    gboolean print_header;
    gboolean print_numbers;
    gint print_every_n_lines;
    gboolean print_with_wrap;

    // Style settings
    gboolean use_gtk_theme;
    gchar font_name[256];
    GdkFont *font;
    gchar italic_name[256];
    GdkFont *italic;
    gchar bold_name[256];
    GdkFont *bold;
    gchar boldi_name[256];
    GdkFont *boldi;
    GdkColor fg;
    GdkColor bg;
    GdkColor s_bg;
    GdkColor bm_bg;
    GdkColor gutter_bg;
    GdkColor nb_normal;
    GdkColor nb_changed;
    GnomePixmap *bg_pixmap;
    gchar pixmap_name[256];
};

typedef struct preferences Preferences;

void edit_preferences(GtkWidget *widget, gpointer data);
GtkWidget *make_button(gchar *button_text, GtkWidget *which_box, gint *value);
void kill_widget_ptr(GtkWidget *w, GtkWidget **widget);

extern Preferences general_preferences;
extern Preferences backup_preferences;
extern Preferences default_preferences;

enum {
   FONT_NORMAL,
   FONT_ITALIC,
   FONT_BOLD, 
   FONT_BOLD_ITALIC
};

#ifdef __cplusplus
}
#endif

#endif
