/* --< GKrellStock 0.2 >--{ 6 Aug 2001 }--
 *
 * Author: M.R.Muthu Kumar (m_muthukumar@users.sourceforge.net)
 *
 */

#include <gkrellm/gkrellm.h>

#define GKRELLSTOCK_VER 	"0.2"
#define DEFAULT_TICKERS		"T SPTN GE" 
#define COMMAND			"GetQuote"
#define DELIM			"!"

#define	CONFIG_NAME	"GkrellStock"	/* Name in the configuration window */
#define	STYLE_NAME	"GkrellStock"	/* Theme subdirectory name */
			                /*  and gkrellmrc style name.*/ 


#define MAX_TICKERS	51	/* Maximum Tickers */
#define DETAIL_ELEM	8	/* Number of Ticker Detail Elements */
#define DEFAULT_SI	30	/* Default Switch Interval */
#define DEFAULT_UI	5	/* Default Update Interval */

#define USA_M		"USA Markets       "
#define EURO_M		"European Markets  "
#define AUS_M		"Australian Markets"
#define CAN_M		"Canadian Markets  "
#define ASIA_M		"Asian Markets     "

/*    net update status    */
static gboolean    net_update;

static Panel	*panel;

static Decal	*decal_text1[MAX_TICKERS];

static gchar	scroll_text[MAX_TICKERS][512];
static gchar	tic_details[MAX_TICKERS][DETAIL_ELEM][512];

static gint		style_id;

static gint panel_state = 0;
static gint x_scroll  = 0;
static gint active_tickers = 0;
static gint switch_interval;
static gint update_interval;
static gint stock_src;


static GtkWidget	*switch_interval_option, 
                        *update_interval_option,
                        *ticker_option,
			*usa_markets,
			*euro_markets,
			*can_markets,
			*asia_markets,
			*aus_markets;

static GtkTooltips  *stock_tips = 0;
static gchar        *stock_tips_text;

gchar filename[512];
gchar *stock_src_name[] = { "usa", "europe", "australia", "canada", "asia" };
gchar tickers[1024];
gchar command[4096];

static gint
expose_event (GtkWidget *widget, GdkEventExpose *ev)
{
    if (widget == panel->drawing_area)
    {
        gdk_draw_pixmap(widget->window,
            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
            panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
            ev->area.width, ev->area.height);
    }
    return FALSE;
}

static FILE *command_pipe;

static void
run_command ()
{
    if (command_pipe)
        return;
    command_pipe = popen(command, "r");
    if (command_pipe)
        fcntl(fileno(command_pipe), F_SETFL, O_NONBLOCK);
    net_update = TRUE;
}

static gboolean
command_done ()
{
    gchar buf[64];

    while (fread(buf, 1, sizeof(buf) - 1, command_pipe) > 0)
        ;
    if (feof(command_pipe))
    {
        pclose(command_pipe);
        command_pipe = NULL;
        return TRUE;
    }
    return FALSE;
}

static void
show_stock_tips()
{
   gchar str[4096];

   if ( stock_tips != NULL )
   {
      g_free( stock_tips_text);	   
      sprintf( str, "%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n", 
		    tic_details[panel_state][0] , 
		    tic_details[panel_state][1] ,
		    tic_details[panel_state][2] ,
		    tic_details[panel_state][3] ,
		    tic_details[panel_state][4] ,
		    tic_details[panel_state][5] ,
		    tic_details[panel_state][6] ,
		    tic_details[panel_state][7] 
		    );

      stock_tips_text = g_strdup(str);
      gtk_tooltips_set_tip(stock_tips, panel->drawing_area,
                           stock_tips_text, NULL);
   }	   
}	

static gboolean
read_stock()
{
  FILE *fp;

  gint i = 0;
  gint j = 0;

  gchar tmp_buff[4096];

  gchar *token;

  if ( ( fp = fopen( filename, "r" ) ) != NULL )
  {
    while ( feof( fp ) == 0  )
    {
      if ( fgets( tmp_buff, 4096, fp ) != NULL )
      {
	token = strtok( tmp_buff, DELIM );
	if ( token != NULL )
	{
	  strcpy(scroll_text[i], token); 

	  j = 0;
	  while( ( token = strtok( NULL, DELIM ) ) != NULL )
          {
            strcpy( tic_details[i][j], token );
	    j++;
            if ( j >= DETAIL_ELEM ) { break; }
	  }	  
          i++;
	}  
      }	

      if ( i >= MAX_TICKERS ) { break; }
    }
    active_tickers = i - 1;

    show_stock_tips();
  }
  else
  {
    sprintf( scroll_text[0], "Error Reading Stock Data" );
  }


  if (fp) { fclose( fp ); }

  return TRUE;

}
static void
draw_panel ()
{
  gint i = 0;


  static gint	w;

  i = panel_state;

  if (w == 0)
	w = gkrellm_chart_width();
   x_scroll = (x_scroll + 1) % (2 * w);
   decal_text1[i]->x_off = w - x_scroll;
   gkrellm_draw_decal_text(panel, decal_text1[i], scroll_text[i], w - x_scroll);
}


static void
panel_switch()
{

   gint old_state;

   old_state = panel_state;
   panel_state++;
   if ( panel_state > active_tickers ) { panel_state = 0 ; }
   gkrellm_make_decal_invisible(panel, decal_text1[old_state] );
   gkrellm_make_decal_visible(panel, decal_text1[panel_state] );

   show_stock_tips();
}	


static gint
panel_press (GtkWidget *widget, GdkEventButton *ev)
{
    if (ev->button == 2 || ev->button == 3)
    {
       panel_switch();	
    }
    return TRUE;
}

static void
update_plugin()
{
	static gint	switch_timer = 0, minute_timer = 0;


	if ( command_pipe )
	{
	  net_update = command_done() && read_stock();
	}	

	if(!net_update && GK.timer_ticks % 600 == 0)
        {
          run_command();
        }

        if ( GK.second_tick && switch_interval > 0 && 
             switch_timer++ >= switch_interval )
        {
          switch_timer = 0;

	  panel_switch();
        }
	if (GK.minute_tick && ++minute_timer >= update_interval)
        {
          minute_timer = 0;
          run_command();
        }

        draw_panel();
	gkrellm_draw_layers(panel);

}



static void
create_plugin(GtkWidget *vbox, gint first_create)
{
	Style			*style;
	TextStyle		*ts, *ts_alt;
	gint			y;
	gint			i = 0;
	gint			j = 0;
	gint			prev_state = 0;

	if (first_create)
	{
	  panel = gkrellm_panel_new0();
	}  
	else 
	{ 
	  gkrellm_destroy_krell_list(panel);
	  gkrellm_destroy_decal_list(panel); 
	}

	style = gkrellm_meter_style(style_id);

	/* Each Style has two text styles.  The theme designer has picked the
	|  colors and font sizes, presumably based on knowledge of what you draw
	|  on your panel.  You just do the drawing.  You probably could assume
	|  the ts font is larger than the ts_alt font, but again you can be
	|  overridden by the theme designer.
	*/
	ts = gkrellm_meter_textstyle(style_id);
	ts_alt = gkrellm_meter_alt_textstyle(style_id);
	panel->textstyle = ts;		/* would be used for a panel label */

	/* Create a text decal that will be used to scroll text.  Make it
	|  the full panel width (minus the margins).  Position it at top border
	|  and left margin of the style.
	*/
        for ( i = 0; i < MAX_TICKERS; i++ )
        {
	  decal_text1[i] = gkrellm_create_decal_text(panel, "Ay", ts, style, -1, -1, -1);
	  y = decal_text1[i]->y + decal_text1[i]->h + 2;

	  for ( j = 0; j < DETAIL_ELEM; j++ )
          {
	     strcpy( tic_details[i][j], "" );
	  }
        }

	/* Configure the panel to hold the above created decals, add in a little
	|  bottom margin for looks, and create the panel.
	*/
        gkrellm_configure_panel(panel, NULL, style);
        gkrellm_create_panel(vbox, panel, gkrellm_bg_meter_image(style_id));
        gkrellm_monitor_height_adjust(panel->h);

	/* Note: all of the above gkrellm_draw_decal_XXX() calls will not
	|  appear on the panel until a 	gkrellm_draw_layers(panel); call is
	|  made.  This will be done in update_plugin(), otherwise we would
	|  make the call here and anytime the decals are changed.
	*/


        if (stock_tips == NULL)
        {
          stock_tips = gtk_tooltips_new();
          stock_tips_text = g_strdup("GKrellStock");
          gtk_tooltips_set_tip(stock_tips, panel->drawing_area,
                               stock_tips_text, NULL);
          gtk_tooltips_set_delay(stock_tips, 1000);
        }

        x_scroll = 0;

        for ( i = MAX_TICKERS - 1; i >=0; i-- )
        {
          panel_state = i; 
	  draw_panel();
	  if ( i == 0 ) { prev_state = i; }
	  else { prev_state = i - 1; }

          gkrellm_make_decal_invisible(panel, decal_text1[panel_state] );
          gkrellm_make_decal_visible(panel, decal_text1[prev_state] );
        }


	if (first_create)
	{	
	    gtk_signal_connect(GTK_OBJECT (panel->drawing_area), "expose_event",
    	        (GtkSignalFunc) expose_event, NULL);
	  gtk_signal_connect(GTK_OBJECT(panel->drawing_area),
            "button_press_event", (GtkSignalFunc) panel_press, NULL);
	}  

}
#define PLUGIN_CONFIG_KEYWORD    "gkrellstock"

static void
save_stock_config (FILE *f)
{
    fprintf(f, "%s update_int %d\n", PLUGIN_CONFIG_KEYWORD,
            update_interval);
    fprintf(f, "%s switch_int %d\n", PLUGIN_CONFIG_KEYWORD,
            switch_interval);
    fprintf(f, "%s stock_src %d\n", PLUGIN_CONFIG_KEYWORD,
            stock_src);
    fprintf(f, "%s tickers %s\n", PLUGIN_CONFIG_KEYWORD, tickers);
}

static void
load_stock_config (gchar *arg)
{
    gchar config[64], item[1024];
    gint n;

    n = sscanf(arg, "%s %[^\n]", config, item);
    if (n == 2)
    {
        if (strcmp(config, "update_int") == 0)
            sscanf(item, "%d\n", &(update_interval));
        if (strcmp(config, "switch_int") == 0)
            sscanf(item, "%d\n", &(switch_interval));
        if (strcmp(config, "stock_src") == 0)
            sscanf(item, "%d\n", &(stock_src));
        if (strcmp(config, "tickers") == 0)
	{	
            strcpy(tickers, item);
            sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
	}    
    }
}

static void
apply_stock_config (void)
{
    gchar *c;

    c = gtk_entry_get_text(GTK_ENTRY(ticker_option));
    if (strcmp(tickers, c)) {
	strcpy( tickers, c );    
        sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
        run_command();
    }

    update_interval = gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(update_interval_option));
    switch_interval = gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(switch_interval_option));
}

static void stock_src_set(GtkWidget *w, gpointer data)
{
    stock_src = GPOINTER_TO_INT(data);
    sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );

    run_command();
}


static void
create_stock_tab (GtkWidget *tab)
{
    GtkWidget *laptop, *frame, *ybox, *hbox, *zbox, *vbox,
              *label, *text, *info_window, *about_label;
    GtkAdjustment *switch_adjust, *update_adjust;
    GSList *markets_group = NULL;

    gchar *about_text = NULL;
    static gchar *help_text[] =
    {
      "<b>" CONFIG_NAME " " GKRELLSTOCK_VER "\n\n" ,
      "Shows stock quotes for given tickers for " ,
      "<i> maximum of 50. \n\n" ,
      "Right click the panel to toggle between different tickers.\n" ,
      "Tooltip will give details of that Ticker.\n\n" ,
      "<b> Options \n\n" ,
      "switch interval - number of seconds between display switch.\n",
      "update interval - number of minutes between updating tickers. \n\n" ,
      "<b> Source Stock Exchange \n\n", 
      " For Europe and Asia Tickers must be entered like SYMBOL.EXCHANGE \n\n" ,
      "<i> e.g. 12150.PA for Paris Exchange \n" ,
      "<i> e.g. CREA.SI for Singapore Exchange \n\n" ,
      "Please check Finance::Quote perl Module documentation " ,
      "for more details \n" ,
      "http://finance-quote.sourceforge.net/documentation.html "
    };
    laptop = gtk_notebook_new();
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(laptop), GTK_POS_TOP);
    gtk_box_pack_start(GTK_BOX(tab), laptop, TRUE, TRUE, 0);

    /* options */
    frame = gtk_frame_new(NULL);
    gtk_container_border_width(GTK_CONTAINER(frame), 3);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 3);

    /* Tickers */
    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Space separated Tickers" );
    ticker_option = gtk_entry_new_with_max_length(1000);
    gtk_entry_set_text(GTK_ENTRY(ticker_option), tickers);
    gtk_entry_set_editable(GTK_ENTRY(ticker_option), TRUE);
    // gtk_container_add(GTK_CONTAINER(hbox), label);
    // gtk_container_add(GTK_CONTAINER(hbox), ticker_option);
    
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), ticker_option, TRUE, TRUE, 0);

    gtk_container_add(GTK_CONTAINER(vbox), hbox);

    /* Source Stock Exchange Radio Buttons */
    zbox = gtk_vbox_new(FALSE, 0);

    ybox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Source Stock Exchange");
    gtk_container_add(GTK_CONTAINER(zbox), label);

    usa_markets = gtk_radio_button_new_with_label(NULL, USA_M );
    markets_group = gtk_radio_button_group(
            GTK_RADIO_BUTTON(usa_markets));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usa_markets),
        stock_src == 0);
    gtk_signal_connect(GTK_OBJECT(usa_markets), "pressed",
         (GtkSignalFunc) stock_src_set, GINT_TO_POINTER(0));
    gtk_container_add(GTK_CONTAINER(ybox), usa_markets);

    euro_markets = gtk_radio_button_new_with_label(markets_group, EURO_M );
    markets_group = gtk_radio_button_group(
            GTK_RADIO_BUTTON(euro_markets));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(euro_markets), 
		    stock_src == 1);
    gtk_signal_connect(GTK_OBJECT(euro_markets), "pressed",
         (GtkSignalFunc) stock_src_set, GINT_TO_POINTER(1));
    gtk_container_add(GTK_CONTAINER(ybox), euro_markets);


    gtk_container_add(GTK_CONTAINER(zbox), ybox);

    ybox = gtk_hbox_new(FALSE, 0);
    aus_markets = gtk_radio_button_new_with_label(markets_group, AUS_M );
    markets_group = gtk_radio_button_group( GTK_RADIO_BUTTON(aus_markets));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(aus_markets), 
		    stock_src == 2);
    gtk_signal_connect(GTK_OBJECT(aus_markets), "pressed",
         (GtkSignalFunc) stock_src_set, GINT_TO_POINTER(2));
    gtk_container_add(GTK_CONTAINER(ybox), aus_markets);

    can_markets = gtk_radio_button_new_with_label(markets_group, CAN_M );
    markets_group = gtk_radio_button_group( GTK_RADIO_BUTTON(can_markets));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(can_markets), 
		    stock_src == 3);
    gtk_signal_connect(GTK_OBJECT(can_markets), "pressed",
         (GtkSignalFunc) stock_src_set, GINT_TO_POINTER(3));

    gtk_container_add(GTK_CONTAINER(ybox), can_markets);

    gtk_container_add(GTK_CONTAINER(zbox), ybox);

    asia_markets = gtk_radio_button_new_with_label(markets_group, ASIA_M );
    markets_group = gtk_radio_button_group( GTK_RADIO_BUTTON(asia_markets));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(asia_markets), 
		    stock_src == 4);
    gtk_signal_connect(GTK_OBJECT(asia_markets), "pressed",
         (GtkSignalFunc) stock_src_set, GINT_TO_POINTER(4));

    gtk_container_add(GTK_CONTAINER(zbox), asia_markets);

    gtk_container_add(GTK_CONTAINER(vbox), zbox);

    /* Switch & Update Interval */

    ybox = gtk_hbox_new(FALSE, 0);
    switch_adjust = (GtkAdjustment *) gtk_adjustment_new((gfloat)
            switch_interval, DEFAULT_SI, 100.0, 1.0, 5.0, 0.0);
    switch_interval_option = gtk_spin_button_new(switch_adjust, 1.0, 1);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(switch_interval_option),
            (guint) 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(switch_interval_option),
            switch_interval);
    gtk_box_pack_start(GTK_BOX(ybox), switch_interval_option, FALSE, FALSE, 0);
    label = gtk_label_new("switch interval (secs)");
    gtk_box_pack_start(GTK_BOX(ybox), label, FALSE, FALSE, 0);
    // gtk_container_add(GTK_CONTAINER(vbox), ybox);

    // ybox = gtk_hbox_new(FALSE, 0);
    update_adjust = (GtkAdjustment *) gtk_adjustment_new((gfloat)
            update_interval, DEFAULT_UI, 100.0, 1.0, 5.0, 0.0);
    update_interval_option = gtk_spin_button_new(update_adjust, 1.0, 1);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(update_interval_option),
            (guint) 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(update_interval_option),
            update_interval);
    label = gtk_label_new("update interval (minutes)");

    gtk_box_pack_end(GTK_BOX(ybox), label, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(ybox), update_interval_option, FALSE, FALSE, 0);

    gtk_container_add(GTK_CONTAINER(vbox), ybox);


    label = gtk_label_new("Options");
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), frame, label);

        /* help */
    frame = gtk_frame_new(NULL);
    gtk_container_border_width(GTK_CONTAINER(frame), 3);
    info_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(info_window),
    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add(GTK_CONTAINER(frame), info_window);

    text = gtk_text_new(NULL, NULL);

    gkrellm_add_info_text(text, help_text, sizeof(help_text)/sizeof(gchar*));
    gtk_text_set_editable(GTK_TEXT(text), FALSE);
    gtk_container_add(GTK_CONTAINER(info_window), text);

    label = gtk_label_new("Help");
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), frame, label);

        /* about */
    about_text = g_strdup_printf(
        "GKrellStock %s\n" \
        "GKrellM Stock Plugin\n" \
        "\n" \
        "Copyright (C) 2001 M.R.Muthu Kumar\n" \
        "m_muthukumar@users.sourceforge.net\n" \
        "\n" \
        "Released under the GNU Public License\n" \
	"GkrellStock comes with ABSOLUTELY NO WARRANTY\n" \
	"Stock Quotes are delayed and Terms and Conditions for \n" \
	"using this information are bound by Finance::Quote module \n" \
	"and Yahoo! Finance \n" \
        , GKRELLSTOCK_VER
    );
    about_label = gtk_label_new(about_text);
    g_free(about_text);
    label = gtk_label_new("About");
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), about_label, label);

}


/* The monitor structure tells GKrellM how to call the plugin routines.
*/
static Monitor	plugin_mon	=
	{
	CONFIG_NAME,        	/* Name, for config tab.    */
	0,			/* Id,  0 if a plugin       */
	create_plugin,		/* The create function      */
	update_plugin,		/* The update function      */
	create_stock_tab,	/* The config tab create function   */
	apply_stock_config,	/* Apply the config function        */ 
	save_stock_config,	/* Save user config*/
	load_stock_config,	/* Load user config*/
	PLUGIN_CONFIG_KEYWORD,	/* config keyword*/ 
	NULL,			/* Undefined 2	*/
	NULL,			/* Undefined 1	*/
	NULL,			/* private		*/ 
	MON_MAIL,		/* Insert plugin before this monitor*/ 
	NULL,			/* Handle if a plugin, filled in by GKrellM */
	NULL			/* path if a plugin, filled in by GKrellM   */
	};

static void
read_default(void)
{
   switch_interval = DEFAULT_SI;
   update_interval = DEFAULT_UI;
   stock_src = 0;

   strcpy( tickers, DEFAULT_TICKERS );

   sprintf( filename, "%s/.smStockReports/stockinfo.dat", getenv( "HOME" ) );
   sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
}	

  /* All GKrellM plugins must have one global routine named init_plugin()
  |  which returns a pointer to a filled in monitor structure.
  */
Monitor *
init_plugin()
	{
	/* If this call is made, the background and krell images for this plugin
	|  can be custom themed by putting bg_meter.png or krell.png in the
	|  subdirectory STYLE_NAME of the theme directory.  Text colors (and
	|  other things) can also be specified for the plugin with gkrellmrc
	|  lines like:  StyleMeter  STYLE_NAME.textcolor orange black shadow
	|  If no custom themeing has been done, then all above calls using
	|  style_id will be equivalent to style_id = DEFAULT_STYLE_ID.
	*/
	/* style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME); */

	style_id = gkrellm_lookup_meter_style_id(CAL_STYLE_NAME);


	read_default();

	/* run_command(); */

	net_update = FALSE;

	return &plugin_mon;
	}
