/* GKrellM Volume plugin
 |  Copyright (C) 1999-2000 Sjoerd Simons
 |
 |  Author:  Sjoerd Simons  sjoerd@luon.net
 |
 |  This program is free software which I release under the GNU General Public
 |  License. You may redistribute and/or modify this program under the terms
 |  of that license as published by the Free Software Foundation; either
 |  version 2 of the License, or (at your option) any later version.
 |
 |  This program is distributed in the hope that it will be useful,
 |  but WITHOUT ANY WARRANTY; without even the implied warranty of
 |  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |  GNU General Public License for more details.
 |
 |  To get a copy of the GNU General Puplic License,  write to the
 |  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mixer.h"
#include "common_mixer.h"

/* adds an id to the mixer list */
mixer_idz_t *mixer_id_list_add(char *id,mixer_idz_t *list) {
  mixer_idz_t *new = malloc(sizeof(mixer_idz_t));
  mixer_idz_t *n;

  new->id = strdup(id);
  new->next = NULL;
  if (list == NULL) 
    return new;

  for (n = list; n->next != NULL; n = n->next);
  n->next = new;
  return list;
}

void mixer_free_idz(mixer_idz_t *idz) {
  mixer_idz_t *tmp;
  mixer_idz_t *next = idz;

  while (next != NULL) {
    tmp = next; next = next->next;
    free(tmp->id);
    free(tmp);
  }
}
