/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
|
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


typedef struct
	{
	gchar		*name;
	GtkWidget	*vbox;
	Chart		*chart;
	ChartConfig	*chart_config;
	ChartData	*sys_cd,
				*user_cd,
				*nice_cd;
	gint		enabled;
	gint		extra_info;
	gint		is_composite;
	gulong		previous_total;

	Decal		*sensor_decal,		/* temperature and possibly fan */
				*fan_decal;			/* fan if separate draw mode	*/
	gint		mapped_sensors;		/* Which of temp/fan to show	*/
	gint		save_label_position;  /* When toggling sensors on/off */

	Launcher	launch;
	GtkWidget	*launch_entry,
				*tooltip_entry;

	gulong		user,		/* Data filled in by system dependent routine */
				nice,
				sys,
				idle;
	}
	CpuMon;

typedef struct
	{
	gchar		*name;
	GtkWidget	*vbox;
	GtkWidget	*enable_button;
	Chart		*chart;
	ChartData	*rb_cd,
				*wb_cd;
	ChartConfig	*chart_config;
	gint		enabled;
	gint		major,
				minor,
				order;
	gint		new_disk;
	gint		extra_info;
	Launcher	launch;
	GtkWidget	*launch_entry,
				*tooltip_entry;
	GtkWidget	*launch_table;

	guint		rblk,		/* Data filled in by system dependent routine */
				wblk;
	}
	DiskMon;


extern GList	*cpu_mon_list,
				*disk_mon_list;

extern void		read_proc_stat();

extern	DiskMon	*composite_disk;

DiskMon	*lookup_disk_by_device(gint, gint);

