/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gkrellm.h"
#include "gkrellm_private_proto.h"

#include <sys/utsname.h>

/* ----------------------------------------------------------------------*/
/* Hostname label on the top frame event_box. */

static Monitor		*mon_host;

static Panel		*host;
static Decal		*decal_host;
static Decal		*decal_sysname;

static GtkWidget	*host_vbox;

static gint			style_id;

static gboolean		hostname_visible,
					hostname_short,
					system_name_visible;

static gchar		hostname[128],
					*system_name;

static gint
host_expose_event(GtkWidget *widget, GdkEventExpose *ev)
	{
	if (widget == host->drawing_area)
		{
		gdk_draw_pixmap(widget->window, GK.draw1_GC, host->pixmap,
			ev->area.x, ev->area.y, ev->area.x, ev->area.y,
			ev->area.width, ev->area.height);
		}
	return FALSE;
	}


static void
draw_hostname(void)
	{
	TextStyle	*ts;
	gchar		*s, buf[128];
	gint		w;

	if (decal_host)
		{
		ts = gkrellm_meter_textstyle(style_id);
		strncpy(buf, hostname, sizeof(buf) - 1);
		buf[sizeof(buf) - 1] = '\0';
		if (GK.hostname_short)		/* XXX */
			{
			s = strchr(buf, (int) '.');
			if (s)
				*s = '\0';
			}
		w = gdk_string_width(ts->font, buf);
		if (w > decal_host->w)
			{
			ts = gkrellm_meter_alt_textstyle(style_id);
			w = gdk_string_width(ts->font, buf);
			}
		decal_host->x_off = (decal_host->w - w) / 2;
		if (decal_host->x_off < 0)
			decal_host->x_off = 0;
		decal_host->text_style.font = ts->font;
		gkrellm_draw_decal_text(host, decal_host, buf, -1);
		}
	if (decal_sysname)
		{
		ts = gkrellm_meter_textstyle(style_id);
		w = gdk_string_width(ts->font, system_name);
		if (w > decal_sysname->w)
			{
			ts = gkrellm_meter_alt_textstyle(style_id);
			w = gdk_string_width(ts->font, system_name);
			}
		decal_sysname->x_off = (decal_sysname->w - w) / 2;
		if (decal_sysname->x_off < 0)
			decal_sysname->x_off = 0;
		decal_sysname->text_style.font = ts->font;
		gkrellm_draw_decal_text(host, decal_sysname, system_name, -1);
		}
	if (decal_host || decal_sysname)
		gkrellm_draw_panel_layers(host);
	}

void
create_hostname(GtkWidget *vbox, gint first_create)
	{
	struct utsname	utsn;
	Style			*style;
	gint			yy, y, l, r, w, a, d;

	if (first_create)
		host = gkrellm_panel_new0();
	host_vbox = vbox;

	if (gethostname(hostname, sizeof(hostname)))
		strcpy(hostname, "unknown");

	g_free(system_name);
	system_name = NULL;
	if (!uname(&utsn))
		system_name = g_strdup_printf("%s %s", utsn.sysname, utsn.release);

	style = gkrellm_meter_style(style_id);

	decal_host = decal_sysname = NULL;
	y = yy = 0;
	if (GK.enable_hostname)
		{
		decal_host = gkrellm_create_decal_text(host, hostname,
					gkrellm_meter_textstyle(style_id), style, -1, -1, -1);
		gdk_string_extents(decal_host->text_style.font, hostname,
					&l, &r, &w, &a, &d);
		yy = (d > 0) ? 0 : 1;
		y = decal_host->h + ((d > 0) ? 1 : 3);
		}
	if (GK.enable_system_name && system_name)
		{
		decal_sysname = gkrellm_create_decal_text(host, system_name,
					gkrellm_meter_textstyle(style_id), style, -1, -1, -1);
		decal_sysname->y += y;
		gdk_string_extents(decal_sysname->text_style.font, system_name,
					&l, &r, &w, &a, &d);
		yy = (d > 0) ? 0 : 1;
		}

	if (decal_host || decal_sysname)
		{
		gkrellm_panel_configure(host, NULL, style);
		gkrellm_panel_configure_add_height(host, yy);
		}
	else
		gkrellm_panel_configure_add_height(host, window_decorations ? 5 : 3);

	gkrellm_panel_create(vbox, mon_host, host);

	if (first_create)
		gtk_signal_connect(GTK_OBJECT(host->drawing_area), "expose_event",
				(GtkSignalFunc) host_expose_event, NULL);

	hostname_visible = GK.enable_hostname;
	hostname_short = GK.hostname_short;
	system_name_visible = GK.enable_system_name;
	draw_hostname();
	}

void
apply_hostname_config(void)
	{
	if (   hostname_visible != GK.enable_hostname
		|| system_name_visible != GK.enable_system_name
	   )
		{
		hostname_visible = GK.enable_hostname;
		system_name_visible = GK.enable_system_name;
		gkrellm_panel_destroy(host);
		create_hostname(host_vbox, TRUE);
		}
	else if (GK.hostname_short != hostname_short)
		{
		hostname_short = GK.hostname_short;
		draw_hostname();
		}
	}


static Monitor	monitor_host =
	{
	NULL,		/* Name, for config tab. Done in General config */
	MON_HOST,	/* Id,  0 if a plugin		*/
	NULL,		/* The create function.  Special call because of event box.*/
	NULL,		/* The update function		*/
	NULL,		/* The config tab create function	*/
	apply_hostname_config,

	NULL,		/* Save user conifg			*/
	NULL,		/* Load user config			*/
	NULL,		/* config keyword			*/

	NULL,				/* Undef 2	*/
	NULL,				/* Undef 1	*/
	NULL,				/* Undef 0	*/

	0,					/* insert_before_id - place plugin before this mon */

	NULL,				/* Handle if a plugin, filled in by GKrellM		*/
	NULL				/* path if a plugin, filled in by GKrellM		*/
	};

Monitor *
init_host_monitor(void)
	{
	style_id = gkrellm_add_meter_style(&monitor_host, HOST_STYLE_NAME);
	mon_host = &monitor_host;
	return &monitor_host;
	}
