/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpcolor_pdb.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#ifndef __GIMP_COLOR_PDB_H__
#define __GIMP_COLOR_PDB_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */


void gimp_brightness_contrast (gint32              drawable_ID,
			       gint                brightness,
			       gint                contrast);
void gimp_levels              (gint32              drawable_ID,
			       GimpChannelLutType  channel,
			       gint                low_input,
			       gint                high_input,
			       gdouble             gamma,
			       gint                low_output,
			       gint                high_output);
void gimp_posterize           (gint32              drawable_ID,
			       gint                levels);
void gimp_desaturate          (gint32              drawable_ID);
void gimp_equalize            (gint32              drawable_ID,
			       gboolean            mask_only);
void gimp_invert              (gint32              drawable_ID);
void gimp_curves_spline       (gint32              drawable_ID,
			       GimpChannelLutType  channel,
			       gint                num_points,
			       guint8             *control_pts);
void gimp_curves_explicit     (gint32              drawable_ID,
			       GimpChannelLutType  channel,
			       gint                num_bytes,
			       guint8             *curve);
void gimp_color_balance       (gint32              drawable_ID,
			       GimpTransferMode    transfer_mode,
			       gboolean            preserve_lum,
			       gdouble             cyan_red,
			       gdouble             magenta_green,
			       gdouble             yellow_blue);
void gimp_histogram           (gint32              drawable_ID,
			       GimpChannelLutType  channel,
			       gint                start_range,
			       gint                end_range,
			       gdouble            *mean,
			       gdouble            *std_dev,
			       gdouble            *median,
			       gdouble            *pixels,
			       gdouble            *count,
			       gdouble            *percentile);
void gimp_hue_saturation      (gint32              drawable_ID,
			       GimpHueRange        hue_range,
			       gdouble             hue_offset,
			       gdouble             lightness,
			       gdouble             saturation);
void gimp_threshold           (gint32              drawable_ID,
			       gint                low_threshold,
			       gint                high_threshold);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIMP_COLOR_PDB_H__ */
