/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpcolor_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_brightness_contrast (gint32 drawable_ID,
			  gint   brightness,
			  gint   contrast)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_brightness_contrast",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, brightness,
				    PARAM_INT32, contrast,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_levels (gint32             drawable_ID,
	     GimpChannelLutType channel,
	     gint               low_input,
	     gint               high_input,
	     gdouble            gamma,
	     gint               low_output,
	     gint               high_output)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_levels",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, channel,
				    PARAM_INT32, low_input,
				    PARAM_INT32, high_input,
				    PARAM_FLOAT, gamma,
				    PARAM_INT32, low_output,
				    PARAM_INT32, high_output,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_posterize (gint32 drawable_ID,
		gint   levels)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_posterize",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, levels,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_desaturate (gint32 drawable_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_desaturate",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_equalize (gint32   drawable_ID,
	       gboolean mask_only)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_equalize",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, mask_only,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_invert (gint32 drawable_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_invert",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_curves_spline (gint32              drawable_ID,
		    GimpChannelLutType  channel,
		    gint                num_points,
		    guint8             *control_pts)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_curves_spline",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, channel,
				    PARAM_INT32, num_points,
				    PARAM_INT8ARRAY, control_pts,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_curves_explicit (gint32              drawable_ID,
		      GimpChannelLutType  channel,
		      gint                num_bytes,
		      guint8             *curve)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_curves_explicit",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, channel,
				    PARAM_INT32, num_bytes,
				    PARAM_INT8ARRAY, curve,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_color_balance (gint32           drawable_ID,
		    GimpTransferMode transfer_mode,
		    gboolean         preserve_lum,
		    gdouble          cyan_red,
		    gdouble          magenta_green,
		    gdouble          yellow_blue)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_color_balance",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, transfer_mode,
				    PARAM_INT32, preserve_lum,
				    PARAM_FLOAT, cyan_red,
				    PARAM_FLOAT, magenta_green,
				    PARAM_FLOAT, yellow_blue,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_histogram (gint32              drawable_ID,
		GimpChannelLutType  channel,
		gint                start_range,
		gint                end_range,
		gdouble            *mean,
		gdouble            *std_dev,
		gdouble            *median,
		gdouble            *pixels,
		gdouble            *count,
		gdouble            *percentile)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_histogram",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, channel,
				    PARAM_INT32, start_range,
				    PARAM_INT32, end_range,
				    PARAM_END);

  *mean = 0.0;
  *std_dev = 0.0;
  *median = 0.0;
  *pixels = 0.0;
  *count = 0.0;
  *percentile = 0.0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *mean = return_vals[1].data.d_float;
      *std_dev = return_vals[2].data.d_float;
      *median = return_vals[3].data.d_float;
      *pixels = return_vals[4].data.d_float;
      *count = return_vals[5].data.d_float;
      *percentile = return_vals[6].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_hue_saturation (gint32       drawable_ID,
		     GimpHueRange hue_range,
		     gdouble      hue_offset,
		     gdouble      lightness,
		     gdouble      saturation)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_hue_saturation",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, hue_range,
				    PARAM_FLOAT, hue_offset,
				    PARAM_FLOAT, lightness,
				    PARAM_FLOAT, saturation,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_threshold (gint32 drawable_ID,
		gint   low_threshold,
		gint   high_threshold)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_threshold",
				    &nreturn_vals,
				    PARAM_DRAWABLE, drawable_ID,
				    PARAM_INT32, low_threshold,
				    PARAM_INT32, high_threshold,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}
