#!/bin/sh

version=`sed -n -e "/AM_INIT_AUTOMAKE(gif2png, \(.*\))/s//\\1/p" <configure.in`
date=`date "+%d %b %Y"`

cat >index.html <<EOF
<!doctype HTML public "-//W3O//DTD W3 HTML 3.2//EN">
<HTML>
<HEAD>
<link rev=made href=mailto:esr@snark.thyrsus.com>
<meta name="description" content="Home page of the gif2png converter">
<meta name="keywords" content="GIF, PNG, converter, graphics"> 
<TITLE>The gif2png home page</TITLE>
</HEAD>
<BODY>
<table width="100%" cellpadding=0><tr>
<td width="30%">Back to <a href="/~esr">Eric's Home Page</a>
<td width="30%" align=center>Up to <a href="/~esr/sitemap.html">Site Map</a>
<td width="30%" align=right>$date
</table>
<HR>
<H1 ALIGN=CENTER>The gif2png home page</H1>

The gif2png program converts files from the obsolescent Graphic
Interchange Format to <a href="http://www.libpng.org/pub/png/">Portable
Network Graphics</a>. The conversion preserves all graphic
information, including transparency, perfectly.  The gif2png program
can even recover data from corrupted GIFs.<p>

The distribution also includes a Python script, web2png, that will convert
entire web hierarchies (images and HTML or PHP pages). The script
requires Python 1.5.2.<p>

The current version is ${version}. The program has actually been functional and
stable for four years. See the <a href="NEWS">NEWS</a> file for more.<p>

You can download a <a href="gif2png-${version}.tar.gz">source tarball</a>,
a <a href="gif2png-${version}.zip">source ZIP archive</a>,
an <a href="gif2png-${version}-1.i386.rpm">Intel binary RPM</a>,
or a <a href="gif2png-${version}-1.src.rpm">source RPM</a> here.<p>

The sources can be built under any Unix, or under MS-DOS or Windows
using djgpp, or using Borland C. I don't know when the djgpp or
Borland builds were last tested, but the Unix version is as stable
as a rock.<p>

Binaries of a Win32 port <a href="http://exe2bin.com/gif2png-win32/">are
available</a>.<p>

Note: Some ImageMagick 4.2.x versions have a bug displaying grayscale 
PNGs that makes it look like gif2png is broken.  It's not.<p>

<H1>History</H1>

This program was written by a German university student named
Alexander Lehmann in 1994-1995. He evolved it to a beta version 0.6
and then dropped off the face of the net.  In Fall 1999, after the
program had been stable and in production use for four years, Greg
Roelofs &lt;<a href="mailto:newt@pobox.com">newt@pobox.com</a>&gt; added some
minor features and released an 0.7 patch.<p>

A short time later, with Greg's consent, I took over maintaining
gif2png in order to give it a proper manual page and release
packaging. Alexander Lehmann is OK with this and has even approved
a change in the license terms to use the libpng/zlib license.<p>

<H1>Patent issues</H1>

The GIF format is encumbered by a <a
href="http://www.patents.ibm.com/details?pn=US04558302__">Unisys
patent</a> for the Lempel-Ziv-Welch compression algorithm.  Use of any
GIF image generator not licensed by Unisys can make you liable to
lawsuit.  Unisys apparently refuses to issue licenses for use of LZW
in open-source programs, and in 1999 <a
href="http://corp2.unisys.com/LeadStory/lzw-license.html">stated</a>
that its policy is to require a \$5000 fee from websites that carry GIF
images made by unlicensed software -- even nonprofit websites created
and displayed with free software.<p>

The patent probably does not cover LZW decompressors such as the one
gif2png uses; legal opinions are divided on this, there has been no court
test, and Unisys refuses to commit itself.  It is possible that
you may be liable if you distribute gif2png in a commercial program,
or distribute gif2png on a for-profit basis.<p>

For a history of the GIF patent controversy, see <a
href="http://lpf.ai.mit.edu/Patents/Gif/Gif.html">http://lpf.ai.mit.edu/Patents/Gif/Gif.html</a>.
To avoid legal problems, it would be a good idea to convert all GIFs
on your websites and elsewhere to PNGs without delay.  See the <a
href="http://burnallgifs.org/">Burn All GIFs Day</a>  site for
discussion.<p>

<H1>Compatibility</H1>

Non-transparent PNGs are displayed correctly in Netscape 4.04 and
later, and in Internet Explorer 4.0b1 and later.  Few current browsers
support transparent PNGs well, or even at all; in deference to this
fact, web2png does not convert GIFs that contain a transparency
index unless you specify the -a (all) option.<p>

<center>
<a href="http://burnallgifs.org/"><IMG SRC="burngifs_60_468.png"></a>
</center>

<HR>
<table width="100%" cellpadding=0><tr>
<td width="30%">Back to <a href="/~esr">Eric's Home Page</a>
<td width="30%" align=center>Up to <a href="/~esr/sitemap.html">Site Map</a>
<td width="30%" align=right>$date
</table>

<P><ADDRESS>Eric S. Raymond <A HREF="mailto:esr@thyrsus.com">&lt;esr@thyrsus.com&gt;</A></ADDRESS>
</BODY>
</HTML>
EOF
