#!/bin/sh

version=`sed -n -e "/AM_INIT_AUTOMAKE(gif2png, \(.*\))/s//\\1/p" <configure.in`
date=`date "+%d%b%Y"`

cat >gif2png.lsm <<EOF
Begin3
Title:		gif2png
Version:	$version
Entered-date:	$date
Description:	The gif2png utility converts GIF images to PNGs, preserving 
		interlacing and transparency.  A companion script, web2png,
		uses gif2png to convert entire web trees, properly modifying
		IMG SRC tags in referencing web pages.
Keywords:	GIF, PNG, converter, graphics
Maintainer:	esr@snark.thyrsus.com (Eric S. Raymond)
Primary-site:	locke.ccil.org /pub/esr/gif2png
		7K gif2png-$version.tar.gz
Platforms:	All
Copying-policy:	libpng/zlib
End
EOF
