/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include <libicq.h>

#include "userinfo.h"
#include "labeledentry.h"


static void info_box_init(InfoBox* ib)
{
  GtkWidget* notebook;
  GtkWidget* vbox, *general_page, *address_page, *info_page;
  GtkWidget* hbox1, *hbox2, *hbox3, *hbox4, *hbox5;
  GtkWidget* vbox1, *vbox2;
  GtkWidget* align, *button_box;

  gtk_window_set_title(GTK_WINDOW(ib), "User Information");

  vbox = gtk_vbox_new(FALSE, 15);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  notebook = gtk_notebook_new();

  general_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(general_page), 5);

  address_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(address_page), 5);

  info_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(info_page), 5);
  
  vbox1 = gtk_vbox_new(FALSE, 0);
  vbox2 = gtk_vbox_new(FALSE, 0);
    
  ib->nick = labeled_entry_new("Nickname: ");
  ib->uin = labeled_entry_new("UIN: ");
  ib->first = labeled_entry_new("First Name: ");
  ib->last = labeled_entry_new("Last Name: ");
  ib->email = labeled_entry_new("E-mail: ");
  ib->age = labeled_entry_new("Age: ");
  ib->sex = labeled_entry_new("Sex: ");
  ib->homepage = labeled_entry_new("  Home Page: ");
  hbox1 = gtk_hbox_new(FALSE, 15);
  hbox2 = gtk_hbox_new(FALSE, 15);
  hbox3 = gtk_hbox_new(FALSE, 15);
  
  gtk_box_pack_start(GTK_BOX(hbox1), ib->nick, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->nick), 70, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->nick), 120, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(hbox1), ib->uin, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->uin), 35, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->uin), 80, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, FALSE, 0);
  
  gtk_box_pack_start(GTK_BOX(hbox2), ib->first, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->first), 70, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->first), 120, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(hbox2), ib->age, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->age), 35, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->age), 80, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(vbox1), hbox2, FALSE, FALSE, 0);
  
  gtk_box_pack_start(GTK_BOX(hbox3), ib->last, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->last), 70, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->last), 120, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(hbox3), ib->sex, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->sex), 35, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->sex), 80, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(vbox1), hbox3, FALSE, FALSE, 0);
  
  gtk_box_pack_start(GTK_BOX(vbox2), ib->email, FALSE, FALSE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->email), 70, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(vbox2), ib->homepage, FALSE, FALSE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->homepage), 70, (gint)NULL);

  gtk_box_pack_start(GTK_BOX(general_page), vbox1, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(general_page), vbox2, FALSE, FALSE, 2);
  
  ib->city = labeled_entry_new("City: ");
  ib->state = labeled_entry_new("State: ");
  ib->country = labeled_entry_new("Country: ");
  ib->phone = labeled_entry_new("Phone: ");
  hbox4 = gtk_hbox_new(FALSE, 15);
  hbox5 = gtk_hbox_new(FALSE, 15);

  gtk_box_pack_start(GTK_BOX(hbox4), ib->city, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->city), 60, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->city), 100, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(hbox4), ib->state, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->state), 60, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->state), 100, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(address_page), hbox4, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(hbox5), ib->country, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->country), 60, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->country), 100, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(hbox5), ib->phone, TRUE, TRUE, 0);
  labeled_entry_set_label_usize(LABELED_ENTRY(ib->phone), 60, (gint)NULL);
  labeled_entry_set_text_usize(LABELED_ENTRY(ib->phone), 100, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(address_page), hbox5, FALSE, FALSE, 0);

  ib->info = gtk_text_new(NULL, NULL);
/*  gtk_widget_set_usize(ib->info, (gint)NULL, 100);  */
  gtk_box_pack_start(GTK_BOX(info_page), ib->info, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

  button_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), 5);
  gtk_box_pack_end(GTK_BOX(vbox), button_box, FALSE, FALSE, 0);
  gtk_widget_show(button_box);

  ib->close = gtk_button_new_with_label("Close");
  GTK_WIDGET_SET_FLAGS(ib->close, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), ib->close, FALSE, FALSE, 0);
  
  gtk_signal_connect_object(GTK_OBJECT(ib->close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)ib);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), general_page, gtk_label_new(" General "));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), address_page, gtk_label_new(" Address "));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), info_page, gtk_label_new(" Info "));

  gtk_container_add(GTK_CONTAINER(ib), vbox);

  gtk_widget_show(ib->nick);
  gtk_widget_show(ib->uin);
  gtk_widget_show(ib->first);
  gtk_widget_show(ib->last);
  gtk_widget_show(ib->email);
  gtk_widget_show(ib->age);
  gtk_widget_show(ib->sex);
  gtk_widget_show(ib->homepage);
  gtk_widget_show(hbox1);
  gtk_widget_show(hbox2);
  gtk_widget_show(hbox3);
  gtk_widget_show(vbox1);
  gtk_widget_show(vbox2);
  gtk_widget_show(general_page);

  gtk_widget_show(ib->city);
  gtk_widget_show(ib->state);
  gtk_widget_show(ib->country);
  gtk_widget_show(ib->phone);
  gtk_widget_show(hbox4);
  gtk_widget_show(hbox5);
  gtk_widget_show(address_page);

  gtk_widget_show(ib->info);
  gtk_widget_show(info_page);

  gtk_widget_show(vbox);
  gtk_widget_show(notebook);

  gtk_widget_show(ib->close);

  gtk_widget_grab_default(ib->close);
}


guint info_box_get_type()
{
         static guint ib_type = 0;
  
         if(!ib_type)
  {
    GtkTypeInfo ib_info =
    {
      "InfoBox",
      sizeof(InfoBox),
      sizeof(InfoBoxClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)info_box_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    ib_type = gtk_type_unique(gtk_window_get_type(), &ib_info);
  }

  return ib_type;
}


GtkWidget* info_box_new()
{
  GtkWidget* IB;
  IB = gtk_type_new(info_box_get_type());
  return IB;
}

