/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include "url.h"
#include "message.h"
#include "labeledentry.h"

#include <sys/types.h>
#include <sys/wait.h>

/* shamelessly yanked from webcontrol applet */
void goto_callback(GtkWidget *entry)
{
        gchar *url;
        gchar *command;
        int status;
        
        url = gtk_entry_get_text(GTK_ENTRY(entry));
  /*        
        if(WC.properties.newwindow) {
                command = malloc(sizeof(gchar) * (strlen(url) + strlen("openURL(, new-window)") + 1));
                sprintf(command, "openURL(%s, new-window)", url);
        } else*/ {
                command = (char*)g_malloc(sizeof(gchar) * (strlen(url) + strlen("openURL()") + 1));
                sprintf(command, "openURL(%s)", url);
        }
                
        if(fork() == 0) {
                /* child  */
                execlp("netscape", "netscape", "-remote", command, NULL);
        } else {
          g_free(command);
                wait(&status);
                if(WEXITSTATUS(status) != 0) {  /* command didn't work */
                        char *argv[3];
                        argv[0] = "netscape";
                        argv[1] = url;
                        argv[2] = NULL;
#ifdef HAVE_GNOME
                        gnome_execute_async (NULL, 2, argv);
#else
      execvp(argv[0], argv);
#endif
                }
        }
}


static void Send(GtkWidget* data)
{
  long uin;
  char* url, *msg;

  uin = atol(gtk_entry_get_text(GTK_ENTRY(LABELED_ENTRY(URL(data)->uin)->entry)));
  url = gtk_entry_get_text(GTK_ENTRY(URL(data)->url));
  msg = gtk_editable_get_chars(GTK_EDITABLE(URL(data)->message), 0, -1);

  ICQ_Send_URL(uin, url, msg);

  g_free(msg);
  gtk_widget_destroy(GTK_WIDGET(data));
}


static void Reply(GtkWidget* data)
{
  GtkWidget* msgbox;

  msgbox = message_new(SEND_MESSAGE,
    atoi(labeled_entry_get_text(LABELED_ENTRY(URL(data)->uin))),
    labeled_entry_get_text(LABELED_ENTRY(URL(data)->nick)));

  gtk_widget_destroy(GTK_WIDGET(data));
  gtk_widget_show(msgbox);
}


static void url_init(Url* m)
{
  GtkWidget* vbox, *info_hbox, *message_hbox;
  GtkWidget *vscrollbar;
  GtkWidget* confirm_area;

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  info_hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_set_usize(info_hbox, (gint)NULL, 27);
  gtk_widget_set_uposition(info_hbox, 12, 21);

  message_hbox = gtk_hbox_new(FALSE, 0);
  m->frame = gtk_frame_new("");
  
  m->uin = labeled_entry_new(" UIN:");
  labeled_entry_set_text(LABELED_ENTRY(m->uin), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->uin), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->uin)->entry, 75, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->uin, TRUE, TRUE, 0);

  m->nick = labeled_entry_new("  Nick:");
  labeled_entry_set_text(LABELED_ENTRY(m->nick), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->nick), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->nick)->entry, 75, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->nick, TRUE, TRUE, 0);

  m->email = labeled_entry_new("  E-mail:");
  labeled_entry_set_text(LABELED_ENTRY(m->email), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->email), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->email)->entry, 120, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->email, TRUE, TRUE, 0);

  m->url = gtk_entry_new();

  m->message = gtk_text_new(NULL, NULL);
  gtk_widget_set_usize(m->message, (gint)NULL, 60);
  vscrollbar = gtk_vscrollbar_new(GTK_TEXT(m->message)->vadj);
  gtk_box_pack_start(GTK_BOX(message_hbox), m->message, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(message_hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_text_set_editable(GTK_TEXT(m->message), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(m->message), TRUE);

  confirm_area = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(confirm_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(confirm_area), 5);
  gtk_box_pack_end (GTK_BOX(vbox), confirm_area, FALSE, FALSE, 0);
  gtk_widget_show(confirm_area);
  
  m->goto_button = gtk_button_new();
  GTK_WIDGET_SET_FLAGS(m->goto_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), m->goto_button, TRUE, TRUE, 0);

  m->action = gtk_button_new();
  GTK_WIDGET_SET_FLAGS(m->action, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), m->action, TRUE, TRUE, 0);

  m->close = gtk_button_new();
  GTK_WIDGET_SET_FLAGS(m->close, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), m->close, TRUE, TRUE, 0);

  gtk_container_add(GTK_CONTAINER(m->frame), info_hbox);
  gtk_box_pack_start(GTK_BOX(vbox), m->frame, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), m->url, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), message_hbox, TRUE, TRUE, 10);
  gtk_container_add(GTK_CONTAINER(m), vbox);

  gtk_signal_connect_object(GTK_OBJECT(m->close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)m);

  gtk_widget_show(m->uin);
  gtk_widget_show(m->nick);
  gtk_widget_show(m->email);
  gtk_widget_show(m->url);
  gtk_widget_show(m->message);
  gtk_widget_show(vscrollbar);
  gtk_widget_show(m->goto_button);
  gtk_widget_show(m->action);
  gtk_widget_show(m->close);

  gtk_widget_show(m->frame);
  gtk_widget_show(info_hbox);
  gtk_widget_show(message_hbox);
  gtk_widget_show(vbox);

  gtk_widget_grab_default(m->action);
}


guint url_get_type()
{
         static guint u_type = 0;
  
         if(!u_type)
  {
    GtkTypeInfo u_info =
    {
      "Url",
      sizeof(Url),
      sizeof(UrlClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)url_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    u_type = gtk_type_unique(gtk_window_get_type(), &u_info);
  }

  return u_type;
}


GtkWidget* url_new(int type, unsigned long uin, char* nick)
{
  GtkWidget* U;
  GtkWidget* action_label, *close_label,*goto_label;
  char str[32];
  U = gtk_type_new(url_get_type());

  if(type == SEND_URL)
  {
    gtk_window_set_title(GTK_WINDOW(U), "Send URL");
    goto_label = gtk_label_new("");
    action_label = gtk_label_new("Send");
    close_label = gtk_label_new("Cancel");
    sprintf(str, "%ld", uin);
    labeled_entry_set_text(LABELED_ENTRY(URL(U)->uin), str);
    labeled_entry_set_text(LABELED_ENTRY(URL(U)->nick), nick);
    gtk_frame_set_label(GTK_FRAME(URL(U)->frame), "To:");
    gtk_signal_connect_object(GTK_OBJECT(URL(U)->action), "clicked",
      GTK_SIGNAL_FUNC(Send), GTK_OBJECT(U));
    gtk_widget_hide(GTK_WIDGET(URL(U)->goto_button));
  }
  else
  {
    gtk_window_set_title(GTK_WINDOW(U), "Incoming URL");
    goto_label = gtk_label_new("Open URL");
    action_label = gtk_label_new("Reply");
    close_label = gtk_label_new("Close");
    gtk_frame_set_label(GTK_FRAME(URL(U)->frame), "From:");
    gtk_signal_connect_object(GTK_OBJECT(URL(U)->goto_button), "clicked",
      GTK_SIGNAL_FUNC(goto_callback), GTK_OBJECT(URL(U)->url));
    gtk_signal_connect_object(GTK_OBJECT(URL(U)->action), "clicked",
      GTK_SIGNAL_FUNC(Reply), GTK_OBJECT(U));
  }

  gtk_container_add(GTK_CONTAINER(URL(U)->goto_button), goto_label);
  gtk_container_add(GTK_CONTAINER(URL(U)->action), action_label);
  gtk_container_add(GTK_CONTAINER(URL(U)->close), close_label);

  gtk_widget_show(goto_label);
  gtk_widget_show(action_label);
  gtk_widget_show(close_label);

  return U;
}

