/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __SEARCH_RESULTS_H__
#define __SEARCH_RESULTS_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SEARCH_RESULTS(obj)        GTK_CHECK_CAST(obj, search_results_get_type(), SearchResults)
#define SEARCH_RESULTS_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, search_results_get_type(), SearchResults)
#define IS_SEARCH_RESULTS(obj)        GTK_CHECK_TYPE(obj, search_results_get_type())

typedef struct _SearchResults SearchResults;
typedef struct _SearchResultsClass SearchResultsClass;

struct _SearchResults
{
  GtkWindow window;

  GtkWidget* results_list;
  GtkWidget* results_scroll_win;
  GtkWidget* add, *close;
};

struct _SearchResultsClass
{
  GtkWindowClass parent_class;
};

guint search_results_get_type(void);
GtkWidget* search_results_new(void* sr);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SEARCH_H__ */
