/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include "message.h"
#include "labeledentry.h"


static void Send(GtkWidget* data)
{
  long uin;
  char* msg, *ptr, str[1024];

  uin = atol(labeled_entry_get_text(LABELED_ENTRY(MESSAGE(data)->uin)));
  msg = gtk_editable_get_chars(GTK_EDITABLE(MESSAGE(data)->message), 0, -1);

  strcpy(str, "");
  ptr = (char *)strtok(msg, "\n");
  while(ptr)
  {
    strcat(str, ptr);
    strcat(str, "\r\n");
    ptr = (char *)strtok(NULL, "\n");
  }

  ICQ_Send_Message(uin, str);

  g_free(msg);
  gtk_widget_destroy(GTK_WIDGET(data));
}


static void Reply(GtkWidget* data)
{
  GtkWidget* msgbox;

  msgbox = message_new(SEND_MESSAGE,
    atoi(labeled_entry_get_text(LABELED_ENTRY(MESSAGE(data)->uin))),
    labeled_entry_get_text(LABELED_ENTRY(MESSAGE(data)->nick)));

  gtk_widget_destroy(GTK_WIDGET(data));
  gtk_widget_show(msgbox);
}


static void message_init(Message* m)
{
  GtkWidget* vbox, *info_hbox, *message_hbox;
  GtkWidget *vscrollbar;
  GtkWidget* confirm_area;

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  info_hbox = gtk_hbox_new(FALSE, 0);
  gtk_widget_set_usize(info_hbox, (gint)NULL, 27);
  gtk_widget_set_uposition(info_hbox, 12, 21);

  message_hbox = gtk_hbox_new(FALSE, 0);
  m->frame = gtk_frame_new("");
  
  m->uin = labeled_entry_new(" UIN:");
  labeled_entry_set_text(LABELED_ENTRY(m->uin), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->uin), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->uin)->entry, 75, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->uin, TRUE, TRUE, 0);

  m->nick = labeled_entry_new("  Nick:");
  labeled_entry_set_text(LABELED_ENTRY(m->nick), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->nick), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->nick)->entry, 75, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->nick, TRUE, TRUE, 0);

  m->email = labeled_entry_new("  E-mail:");
  labeled_entry_set_text(LABELED_ENTRY(m->email), "N/A");
  labeled_entry_set_editable(LABELED_ENTRY(m->email), FALSE);
  gtk_widget_set_usize(LABELED_ENTRY(m->email)->entry, 120, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(info_hbox), m->email, TRUE, TRUE, 0);

  m->message = gtk_text_new(NULL, NULL);
  gtk_widget_set_usize(m->message, (gint)NULL, 100);
  vscrollbar = gtk_vscrollbar_new(GTK_TEXT(m->message)->vadj);
  gtk_box_pack_start(GTK_BOX(message_hbox), m->message, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(message_hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_text_set_editable(GTK_TEXT(m->message), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(m->message), TRUE);


  confirm_area = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(confirm_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(confirm_area), 5);
  gtk_box_pack_end (GTK_BOX(vbox), confirm_area, FALSE, FALSE, 0);
  gtk_widget_show(confirm_area);
  
  m->action = gtk_button_new();
  GTK_WIDGET_SET_FLAGS(m->action, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), m->action, TRUE, TRUE, 0);

  m->close = gtk_button_new();
  GTK_WIDGET_SET_FLAGS(m->close, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), m->close, TRUE, TRUE, 0);

  gtk_container_add(GTK_CONTAINER(m->frame), info_hbox);
  gtk_box_pack_start(GTK_BOX(vbox), m->frame, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), message_hbox, TRUE, TRUE, 10);
  gtk_container_add(GTK_CONTAINER(m), vbox);

  gtk_signal_connect_object(GTK_OBJECT(m->close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)m);

  gtk_widget_show(m->uin);
  gtk_widget_show(m->nick);
  gtk_widget_show(m->email);
  gtk_widget_show(m->message);
  gtk_widget_show(vscrollbar);
  gtk_widget_show(m->action);
  gtk_widget_show(m->close);

  gtk_widget_show(m->frame);
  gtk_widget_show(info_hbox);
  gtk_widget_show(message_hbox);
  gtk_widget_show(vbox);

  gtk_widget_grab_default(m->action);
}


guint message_get_type()
{
         static guint m_type = 0;
  
         if(!m_type)
  {
    GtkTypeInfo m_info =
    {
      "Message",
      sizeof(Message),
      sizeof(MessageClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)message_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    m_type = gtk_type_unique(gtk_window_get_type(), &m_info);
  }

  return m_type;
}


GtkWidget* message_new(int type, unsigned long uin, char* nick)
{
  GtkWidget* M;
  GtkWidget* action_label, *close_label;
  char str[32];
  M = gtk_type_new(message_get_type());

  if(type == SEND_MESSAGE)
  {
    gtk_window_set_title(GTK_WINDOW(M), "Send Message");
    action_label = gtk_label_new("Send");
    close_label = gtk_label_new("Cancel");
    sprintf(str, "%ld", uin);
    labeled_entry_set_text(LABELED_ENTRY(MESSAGE(M)->uin), str);
    labeled_entry_set_text(LABELED_ENTRY(MESSAGE(M)->nick), nick);
    gtk_frame_set_label(GTK_FRAME(MESSAGE(M)->frame), "To:");
    gtk_window_set_focus(GTK_WINDOW(M), MESSAGE(M)->message);
    gtk_signal_connect_object(GTK_OBJECT(MESSAGE(M)->action), "clicked",
      GTK_SIGNAL_FUNC(Send), GTK_OBJECT(M));
  }
  else
  {
    gtk_window_set_title(GTK_WINDOW(M), "Incoming Message");
    action_label = gtk_label_new("Reply");
    close_label = gtk_label_new("Close");
    gtk_frame_set_label(GTK_FRAME(MESSAGE(M)->frame), "From:");
    gtk_text_set_editable(GTK_TEXT(MESSAGE(M)->message), FALSE);
    gtk_signal_connect_object(GTK_OBJECT(MESSAGE(M)->action), "clicked",
      GTK_SIGNAL_FUNC(Reply), GTK_OBJECT(M));
  }

  gtk_container_add(GTK_CONTAINER(MESSAGE(M)->action), action_label);
  gtk_container_add(GTK_CONTAINER(MESSAGE(M)->close), close_label);

  gtk_widget_show(action_label);
  gtk_widget_show(close_label);

  return M;
}

