/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include <libicq.h>

#include "login.h"
#include "event.h"
#include "labeledentry.h"

gint IdleFunction(gpointer data);
gint KeepAlive(gpointer data);

void DoLogin(GtkWidget* data)
{
  gchar* uin_str;
  
  uin_str = labeled_entry_get_text(LABELED_ENTRY(LOGIN(data)->uin));

  if(strcmp(uin_str, ""))
  {
    UIN = atol(uin_str);
    strcpy(passwd, labeled_entry_get_text(LABELED_ENTRY(LOGIN(data)->passwd)));

    gtk_widget_destroy(GTK_WIDGET(data));
    ICQ_Connect();
    AddTimers();
  }
}


static void login_init(Login* l)
{
  GtkWidget* vbox;
  GtkWidget* label;
  GtkWidget* ok;

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  label = gtk_label_new("Enter your UIN and password:");
  l->uin = labeled_entry_new("UIN:");
  l->passwd = labeled_entry_new("Password:");
  labeled_entry_set_max_length(LABELED_ENTRY(l->passwd), 8);
  labeled_entry_set_visibility(LABELED_ENTRY(l->passwd), FALSE);
  ok = gtk_button_new_with_label("OK");

  gtk_signal_connect_object(GTK_OBJECT(ok), "clicked",
    GTK_SIGNAL_FUNC(DoLogin), GTK_OBJECT(l));

  gtk_widget_set_usize(LABELED_ENTRY(l->uin)->label, 65, (gint)NULL);
  gtk_widget_set_usize(LABELED_ENTRY(l->passwd)->label, 65, (gint)NULL);

  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(vbox), l->uin, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), l->passwd, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), ok, FALSE, FALSE, 3);
  gtk_container_add(GTK_CONTAINER(l), vbox);

  gtk_widget_show(label);
  gtk_widget_show(l->uin);
  gtk_widget_show(l->passwd);
  gtk_widget_show(ok);
  gtk_widget_show(vbox);
}


guint login_get_type()
{
         static guint l_type = 0;
  
         if(!l_type)
  {
    GtkTypeInfo l_info =
    {
      "Login",
      sizeof(Login),
      sizeof(LoginClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)login_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    l_type = gtk_type_unique(gtk_window_get_type(), &l_info);
  }

  return l_type;
}


GtkWidget* login_new()
{
  GtkWidget* l;
  l = gtk_type_new(login_get_type());
  gtk_window_set_title(GTK_WINDOW(l), "Login");
  return l;
}




























