/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __INFO_H__
#define __INFO_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define INFO(obj)        GTK_CHECK_CAST(obj, info_get_type(), Info)
#define INFO_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, info_get_type(), Info)
#define IS_INFO(obj)        GTK_CHECK_TYPE(obj, info_get_type())

typedef struct _Info Info;
typedef struct _InfoClass InfoClass;

struct _Info
{
  GtkWindow window;

  GtkWidget* vscrollbar;
  GtkWidget* label;
  GtkWidget* info;
  GtkWidget* close;
};

struct _InfoClass
{
  GtkWindowClass parent_class;
};


guint info_get_type(void);
GtkWidget* info_new(char* title, char* label, char* info);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __INFO_H__ */
