/**
 * getxml-extract:
 * @title: getxml-extract
 * @subtitle: getxml-extract
 * @project: getxml
 * @lang: fr,en
 * @authors: Philippe Roy <ph_roy@toutdoux.org>
 * @copyright: Copyright (c) 2001 Philippe Roy
 * @license: GNU GPL
 *
 * fr: Extraction
 *
 * en: Extrac
 **/

/*
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <glib.h>

/*****************************************************************************/
/*** Arguments de la ligne de commande - Commande line arguments */
/*****************************************************************************/

typedef struct TdPopt_tmp
{
  gchar *key;
  gchar *longkey;
  gchar *description;
  gchar *argument;
  gboolean flag;
  gchar *value;
  gint nbpredef;
  gchar *predef[10];
} TdPopt_tmp, *TdPopt;

TdPopt popt_def (gchar *key, gchar *longkey, gchar *argument, gchar *description);
void popts_help (gint nbpopts, TdPopt popts[]);
void popts_parse (gint argc, char *argv[], gint nbpopts, TdPopt popts[]);
void popts_version (void);

/*****************************************************************************/
/*** Element */
/*****************************************************************************/

void extract (gchar *file);
void sax_start_element (void *ctx, const xmlChar *name, const xmlChar **attrs);

/*****************************************************************************/
/*** Principale - Main */
/*****************************************************************************/

void popts_about (void);
void popts_def (void);
int main (gint argc, char *argv[]);

