/*  $Id$
    PixmapArray.cpp - Object containing an array of Pixmaps.

    gengameng - Generic 2D Game Engine library
    Copyright (C) 1999, 2000, 2001 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include <gengameng/PixmapArray.h>

#include <assert.h>


PixmapArray::PixmapArray(size_t numImages)
  : images(numImages, NULL),
    imageSize(0, 0)
{
    assert(numImages > 0);
}


/*static*/ void
PixmapArray::freePixmap(Pixmap pm)
{
    if (pm != NULL)
	SDL_FreeSurface(pm);
}


void
PixmapArray::freePixmaps()
{
    for (vector<Pixmap>::iterator it = images.begin(); it != images.end(); it++)
	freePixmap(*it);
    images.clear();
}


PixmapArray::~PixmapArray()
{
    freePixmaps();
}


void
PixmapArray::setArrayElement(size_t i, Pixmap image)
{
    assert(i < images.size());
    assert(image != NULL);

    images[i] = image;
}


void
PixmapArray::setImageSize(Couple size)
{
    assert(size.x != 0 && size.y != 0);
    imageSize = size;
}
