dnl AM_PATH_GENGAMENG(MIN-VERSION)
dnl
dnl Test for gengameng, and define GENGAMENG_PREFIX, GENGAMENG_CFLAGS
dnl and GENGAMENG_LIBS.
dnl Calls AC_MSG_ERROR() on failure.
dnl Offers the option --with-gengameng-prefix=DIR.  Default is /usr/local.
dnl
dnl Expects the AM_PATH_SDL to be found in sdl.m4, which should reside in
dnl /usr/share/aclocal/sdl.m4 if SDL was installed normally.
dnl
dnl Example: AM_PATH_GENGAMENG(4.0)
dnl

AC_DEFUN([AM_PATH_GENGAMENG],
[
	dnl Check for SDL (see sdl.m4 and http://www.libsdl.org/).
	dnl Temporarily set language to C because the AC_TRY_RUN() in
	dnl sdl.m4 must use cc instead of c++.

	MIN_GENGAMENG_VERSION=$1  # minimal gengameng version to require

	AC_LANG_C  

	SDL_VERSION=1.2.0
	AM_PATH_SDL($SDL_VERSION,
		:,
		AC_MSG_ERROR([*** SDL version $SDL_VERSION not found!]))

	AC_LANG_CPLUSPLUS


	AC_MSG_CHECKING(for gengameng - version >= $MIN_GENGAMENG_VERSION)

	AC_ARG_WITH(gengameng-prefix,
	[  --with-gengameng-prefix=DIR  Dir prefix where gengameng library is installed],
	[
		_prefix=$withval
	],
	[
		if test -n "$GENGAMENG_PREFIX"; then
			_prefix="$GENGAMENG_PREFIX"
		elif test -d /usr/local/include/gengameng; then
			_prefix=/usr/local
		elif test -d /usr/include/gengameng; then
			_prefix=/usr
		else	
			AC_MSG_ERROR([could not find gengameng library; use --with-gengameng-prefix])
		fi
	])

	if test -f $_prefix/include/gengameng/GameEngine.h; then
		:
	else
		AC_MSG_ERROR([could not find $_prefix/include/gengameng/GameEngine.h;
gengameng devel files may not be installed; see BurgerSpace Home Page])
	fi

	if test -f $_prefix/lib/gengamengConf.sh; then
		. $_prefix/lib/gengamengConf.sh

		# Brackets used in next line for protection against m4:
		MINVER=`echo "$MIN_GENGAMENG_VERSION" | awk -F. '{ printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`
		ACTUAL=`echo "$MODULE_VERSION" | awk -F. '{ printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`
		if test "$ACTUAL" -ge "$MINVER"; then
			AC_MSG_RESULT([found $MODULE_VERSION])
		else
			AC_MSG_ERROR([gengameng >= $MIN_GENGAMENG_VERSION is required; found $MODULE_VERSION])
		fi

		unset MIN_GENGAMENG_VERSION
		unset MINVER
		unset ACTUAL
		unset MODULE_VERSION
	else
		AC_MSG_ERROR([cannot find the gengamengConf.sh file.  gengameng >= $MIN_GENGAMENG_VERSION is required])
	fi

	GENGAMENG_PREFIX="$_prefix"

	unset _prefix

	AC_SUBST(GENGAMENG_PREFIX)

	# These variables come from the gengamengConf.sh file:
	AC_SUBST(GENGAMENG_CFLAGS)
	AC_SUBST(GENGAMENG_LIBS)
])
