/*
 *  krt_rtread_hpstreams.c
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#define	INCLUDE_ROUTE
#define	INCLUDE_KVM
#include "include.h"
#ifdef	PROTO_INET
#include "inet.h"
#endif	/* PROTO_INET */
#ifdef	PROTO_ISO
#include "iso.h"
#endif	/* PROTO_ISO */
#include "krt.h"
#include "krt_var.h"
#include <sys/mib.h>


 /*  Read the kernel's routing table.			*/
int
krt_rtread __PF1(tp, task *)
{
    s_int32 i;
    size_t rtbufsize;
    rt_parms rtparms;
    s_int32 num_routes = 0;
    if_addr *ifap;

    s_int32 fd, count, len;
    struct nmparms parms;
    mib_ipRouteEnt *route_buf, *rtptr;
    flag_t  rt_flag;

    bzero((caddr_t) &rtparms, sizeof (rtparms));
    rtparms.rtp_n_gw = 1;

    trace_only_tp(tp,
                  TRC_NL_BEFORE,
                  ("krt_rtread: Initial routes read from kernel (via
dev/ip MIB):"));

    if ((fd = open_mib("/dev/ip", O_RDWR, 0, 0)) < 0) {
	trace_only_tp(tp,
                      0,
                      ("krt_rtread: open_mib failed: %m"));
         return (EINVAL);
    }

    parms.objid = ID_ipRouteNumEnt;
    parms.buffer = &count;
    len = sizeof(count);
    parms.len = &len;

    if (get_mib_info (fd, &parms) < 0) {
        trace_only_tp(tp,
                      0,
                      ("krt_rtread: Can't get ID_ipRouteNumEnt"));
         close_mib(fd);
         return (EINVAL);
    }

    /* count = Number of route entries  */
    /* set up to read the kernel routing table */
    rtbufsize = count * sizeof(mib_ipRouteEnt);
    if ((route_buf = (mib_ipRouteEnt *) task_block_malloc (rtbufsize)) == 0) {
        trace_only_tp(tp,
                      0,
                      ("krt_rtread: Error in allocating space for the
kernel routing table"));
         close_mib(fd);
         return (EINVAL);
    }
 
    parms.objid = ID_ipRouteTable;
    parms.buffer = route_buf;
    len = count * sizeof(mib_ipRouteEnt);
    parms.len = &len;

    if (get_mib_info (fd, &parms) < 0) {
        trace_only_tp(tp,
                      0,
                      ("krt_rtread: Can't get ID_ipRouteTable"));
         close_mib(fd);
         return (EINVAL);
    }

    close_mib(fd);

    /* map the kernel routing data to gated structure */
    rtptr = route_buf;
    for (i=0; i < count; i++, rtptr++)  {
        if ((rtptr->Type == NMDIRECT) || (rtptr->Type == NMREMOTE) ) {
          rtparms.rtp_dest =  sockbuild_in (0, rtptr->Dest);
          rtparms.rtp_router = sockbuild_in (0, rtptr->NextHop) ;

          rtparms.rtp_state = (flag_t) 0;
          if (rtptr->Type == NMREMOTE) 
              BIT_SET(rtparms.rtp_state, RTS_GATEWAY);

	  /* Determine netmask */
          /*
          if (BIT_TEST(rtptr->Type, NMREMOTE)) {
              rtparms.rtp_dest_mask = inet_mask_default;
          } else {
              rtparms.rtp_dest_mask = inet_mask_locate(rtptr->Mask);
	  }
          */
          rtparms.rtp_dest_mask = inet_mask_locate(rtptr->Mask);

	  krt_rtread_add(tp,
		       &rtparms,
		       krt_state_to_flags(rtparms.rtp_state),
		       FALSE,
		       "REMNANT");
	}
    }
    task_block_reclaim(rtbufsize, (caddr_t) route_buf);

    return 0;
}
