/*
 * Public Release 3
 * 
 * $Id: isis_dual.c,v 1.5 1999/02/17 23:30:33 cwr Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996,1997,1998,1999 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */

#include "include.h"
#include "isis_includes.h"

/*
*	associates an ip address with a circuit entry structure.
*	may be called multiple times, although multiple calls setting
*	the same value ipaddr are ignored.
*
*	This will effect the LSPs that the system generates, although
*	a change instigated here will NOT cause an LSP to be regenerated.
*	(it would basically have to make every lsp numbered zero - pseudo
*	and non pseudonode alike to be rebuilt).
*/
void
addIPAddr __PF2(c, CircuitEntry *,
		ipaddr, struct in_addr)
{
    if (c->ipAddrs.cnt >= MAXIPADDRS) {
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("%s: too many addresses configured",
		      c->name));
    } else {
	c->ipAddrs.addrs[c->ipAddrs.cnt++] = ipaddr;
	buildIPAddrOption();
    }
}

/* DUAL: insert the protocols supported option */
/* if prepend is true, then add the code and length field */
u_char *
insertProtoSup __PF2(
	    bp, u_char *,
	    prepend, Boolean)
{
	if (prepend) {
		*bp++ = ProtoSupportedCode;
		*bp++ = ip_supported + clnp_supported;	/* IP and OSI */
	}
	if (clnp_supported) *bp++ = OSI_NLPID;
	if (ip_supported) *bp++ = IP_NLPID;
	return(bp);
}

/* DUAL: insert the IP interface address option */
/* if prepend is true, then add the code and length field */
u_char *
insertIPaddr __PF3(
	    c, CircuitEntry *,
	    bp, u_char *,
	    prepend, Boolean)
{
    if (c->ipAddrs.cnt) {
	int	i;

	if (prepend) {
	    *bp++ = IPIfAddrCode;
	    *bp++ = sizeof(struct in_addr) * c->ipAddrs.cnt;
	}

	for (i=0; i<c->ipAddrs.cnt; i++) {
	    bcopy((caddr_t)&c->ipAddrs.addrs[i], (caddr_t) bp, sizeof(struct in_addr));
	    bp += sizeof(struct in_addr);
	}
    }
    return(bp);
}


prefIP *
setIPReachable __PF6(
	    level, int,
	    code, u_char,
	    metrics, MetricList,
	    addr, struct in_addr,
	    mask, struct in_addr, 
	    path, as_path *)
{
    prefIP *p = 0;

    if (!(level == 1 || level == 2)) {
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("setIPReachable: bad level %d",
		      level));
	return(p);
    }

    switch(code) {
    case IPIntReachCode:
	metrics.defalt &= 0x3f; 	/* clear I/E bit */
	if (level == 1)
	    p = addIPReachToLSP(L1LSP, metrics, addr, mask, code, path);
	else
	    p = addIPReachToLSP(L2LSP, metrics, addr, mask, code, path);
	break;

    case IPExtReachCode:
	if (level != 2) {
	    trace_log_tf(isis_trace_options,
			 0,
			 LOG_ERR,
			 ("setIPReachable: IPExtReachCode level must be 2"));
	    return(p);
	}
	metrics.defalt |= 0x40; 	/* set I/E bit */
	p = addIPReachToLSP(L2LSP, metrics, addr, mask, code, path);
	break;
	
    default:
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("setIPReachable: bad code %d",
		      code));
	break;
    }
    return(p);
}

void 
clearIPReachable __PF3( level, int,
	    		code, u_char,
			p, prefIP *)
{
    if (!(level == 1 || level == 2)) {
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("clearIPReachable: bad level %d",
		      level));
	return;
    }

    switch(code) {
    case IPIntReachCode:
	delIPReach(p);
	break;
    case IPExtReachCode:
	if (level != 2) {
	    trace_log_tf(isis_trace_options,
			 0,
			 LOG_ERR,
			 ("clearIPReachable: IPExtReachCode level must be 2"));
	    return;
	}
	delIPReach(p);
	break;
    default:
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("clearIPReachable: bad code %d",
		      code));
	break;
    }
}
