/********************************************
 *
 * $GAMGI/src/math/gamgi_math_diophantine.c
 *
 * Copyright (C) 2006 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"

int gamgi_math_diophantine_gcd (int a, int b)
{
/*****************************
 * recursive Euler algorithm *
 *****************************/

if (b == 0) return a;
else return (gamgi_math_diophantine_gcd (b, a % b));
}

void gamgi_math_diophantine_gcd_extended (int a, int b, int *x, int *y, int *gcd)
{
int quotient, temp;
int x0 = 1;
int y0 = 0;
int x1 = 0;
int y1 = 1;

/****************************
 * extended Euler algorithm *
 ****************************/

while (b != 0)
  {
  temp = b;
  quotient = a / b;
  b = a % b;
  a = temp;

  temp = x1;
  x1 = x0 - quotient * x1;
  x0 = temp;

  temp = y1;
  y1 = y0 - quotient * y1;
  y0 = temp;
  }

*x = x0;
*y = y0;
*gcd = a;
}

void gamgi_math_diophantine_swap (int *old1, int *old2, 
int *new1, int *new2, int *swap)
{
int zero1, zero2;
int i, temp;

/**********************************************************
 * count number of zero indices in the two sets of planes *
 **********************************************************/

zero1 = 0;
for (i = 0; i < 3; i++)
  if (old1[i] == 0) zero1++;

zero2 = 0;
for (i = 0; i < 3; i++)
  if (old2[i] == 0) zero2++;

/****************************************
 * swap equations, so the equation with *
 * more zero indices is the first one   *
 ****************************************/

if (zero1 >= zero2)
  {
  new1[0] = old1[0]; new1[1] = old1[1]; new1[2] = old1[2];
  new2[0] = old2[0]; new2[1] = old2[1]; new2[2] = old2[2];
  swap[3] = 0;
  }
else
  {
  new1[0] = old2[0]; new1[1] = old2[1]; new1[2] = old2[2];
  new2[0] = old1[0]; new2[1] = old1[1]; new2[2] = old1[2];
  swap[3] = 1;
  }

/******************************************
 * swap equation terms, so the first term *
 * in the first equation is not zero      *
 ******************************************/

swap[0] = 0;
swap[1] = 1;
swap[2] = 2;

/**************************
 * swap initial 1,2 terms *
 **************************/

if (new1[0] == 0)
  {
  temp = new1[0];
  new1[0] = new1[1];
  new1[1] = temp;

  temp = new2[0];
  new2[0] = new2[1];
  new2[1] = temp;

  swap[0] = 1;
  swap[1] = 0;
  }

/**************************
 * swap initial 1,3 terms *
 **************************/

if (new1[0] == 0)
  {
  temp = new1[0];
  new1[0] = new1[2];
  new1[2] = temp;

  temp = new2[0];
  new2[0] = new2[2];
  new2[2] = temp;

  swap[0] = 2;
  swap[2] = 1;
  }
}

gamgi_bool gamgi_math_diophantine_intersect (int *a, int *b, 
int n1, int n2, int *out)
{
int aa, bb, cc;
int dd, ee, ff;
int x, y, z, t;
int gcd1, gcd2;

/*******************************************************
 * solve a system of two linear diophantine equations  *
 * (each one describing a plane of a different family) *
 * with three variables (the coordinates of a node     *
 * belonging to both planes):                          *
 *                a[0]x + a[1]y + a[2]z = n1           *
 *                b[0]x + b[1]y + b[2]z = n1           *
 *******************************************************/

/*****************************************************
 * if aa == 0 && bb == 0 then the two plane families *
 * are the same, for example: (+1+1-1) and (-1-1+1)  *
 *                                                   *
 * if cc % gcd1 != 0 then no valid solutions exist   *
 * (no node belongs simultaneosusly to both planes)  *
 *****************************************************/

aa = a[0] * b[1] - b[0] * a[1];
bb = a[0] * b[2] - b[0] * a[2];
cc = a[0] * n2 - b[0] * n1;
if (aa == 0 && bb == 0) return FALSE;

gamgi_math_diophantine_gcd_extended (aa, bb, &y, &z, &gcd1);
if (cc % gcd1 != 0) return FALSE;

y *= cc / gcd1;
z *= cc / gcd1;

/*****************************************************
 * if ee == 0 && ff == 0 then the two plane families *
 * are the same, for example: (+1+1-1) and (-1-1+1)  *
 *                                                   *
 * if ff % gcd2 != 0 then no valid solutions exist   *
 * (no node belongs simultaneosusly to both planes)  *
 *****************************************************/

dd = a[0];
ee = (a[1] * bb - a[2] * aa) / gcd1;
ff = n1 - a[1] * y - a[2] * z;
if (dd == 0 && ee == 0) return FALSE;

gamgi_math_diophantine_gcd_extended (dd, ee, &x, &t, &gcd2);
if (ff % gcd2 != 0)
  {
  printf ("hkl1: %d %d %d %d %d %d %d %d\n",
  a[0], a[1], a[2], b[0], b[1], b[2], n1, n2);
  return FALSE;
  }

x *= ff / gcd2;
t *= ff / gcd2;

y += t * bb / gcd1;
z -= t * aa / gcd1;

/*
if (a[0] * x + a[1] * y + a[2] * z != n2) printf ("falhou equacao 1\n");
if (b[0] * x + b[1] * y + b[2] * z != n1) printf ("falhou equacao 2\n");
*/

return TRUE;
}
