/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_EMBED_POPUP_H
#define GALEON_EMBED_POPUP_H

#include "galeon-embed.h"
#include <glib-object.h>
#include <bonobo/bonobo-ui-component.h>

G_BEGIN_DECLS

typedef struct GaleonEmbedPopupClass GaleonEmbedPopupClass;

#define GALEON_TYPE_EMBED_POPUP             (galeon_embed_popup_get_type ())
#define GALEON_EMBED_POPUP(obj)             (GTK_CHECK_CAST ((obj), GALEON_TYPE_EMBED_POPUP, GaleonEmbedPopup))
#define GALEON_EMBED_POPUP_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GALEON_TYPE_EMBED_POPUP, GaleonEmbedPopupClass))
#define GALEON_IS_EMBED_POPUP(obj)          (GTK_CHECK_TYPE ((obj), GALEON_TYPE_EMBED_POPUP))
#define GALEON_IS_EMBED_POPUP_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GALEON_EMBED_POPUP))
#define GALEON_EMBED_POPUP_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GALEON_TYPE_EMBED_POPUP, GaleonEmbedPopupClass))

typedef struct GaleonEmbedPopup GaleonEmbedPopup;
typedef struct GaleonEmbedPopupPrivate GaleonEmbedPopupPrivate;

struct GaleonEmbedPopup 
{
	GObject parent;
        GaleonEmbedPopupPrivate *priv;
};

struct GaleonEmbedPopupClass
{
        GObjectClass parent_class;

	void	(*show)					(GaleonEmbedPopup *p,
							 GaleonEmbed *embed);

	/* signals */
	void	(*before_show)				(GaleonEmbedPopup *p);
};



/* this class is abstract, don't look for the constructor */

GType             	galeon_embed_popup_get_type 		(void);
void		  	galeon_embed_popup_connect_verbs	(GaleonEmbedPopup *p,
								 BonoboUIComponent *ui_component);
void			galeon_embed_popup_set_embed		(GaleonEmbedPopup *p, 
								 GaleonEmbed *e);
GaleonEmbed *		galeon_embed_popup_get_embed		(GaleonEmbedPopup *p);
void		  	galeon_embed_popup_set_event 		(GaleonEmbedPopup *p,
								 GaleonEmbedEvent *event);
GaleonEmbedEvent *	galeon_embed_popup_get_event		(GaleonEmbedPopup *p);
void              	galeon_embed_popup_show			(GaleonEmbedPopup *p,
								 GaleonEmbed *embed);
const char *		galeon_embed_popup_get_popup_path	(GaleonEmbedPopup *p);

G_END_DECLS

#endif
