/**
 * @file meta-presence.h Meta-Presence API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_META_PRESENCE_H_
#define _GALAGOD_META_PRESENCE_H_

typedef struct _GalagodMetaPresence GalagodMetaPresence;

#include <libgalago/galago.h>
#include "meta-account.h"
#include "meta-person.h"

struct _GalagodMetaPresence
{
	GalagoPresence *presence;

	GList *presences;
};

#define GALAGOD_META_PRESENCE(presence) \
	(g_object_get_data(G_OBJECT(presence), "meta-presence"))

GalagodMetaPresence *galagod_meta_presence_new(
	GalagodMetaAccount *meta_account);
void galagod_meta_presence_destroy(GalagodMetaPresence *meta_presence);

GalagoPresence *galagod_meta_presence_get_presence(
	const GalagodMetaPresence *meta_presence);

GList *galagod_meta_presence_get_presences(
	const GalagodMetaPresence *meta_presence);

void galagod_meta_presence_add_presence(GalagodMetaPresence *meta_presence,
										GalagoPresence *presence);
void galagod_meta_presence_remove_presence(GalagodMetaPresence *meta_presence,
										   GalagoPresence *presence);

#endif /* _GALAGOD_META_PRESENCE_H_ */
