/*
 * tvdebug.h
 *
 * Debug macros/state for FXTV.
 *
 * (C) 1998 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVDEBUG_H
#define __TVDEBUG_H

#include <stdio.h>

extern int G_debug;

#define DEBUG_STARTUP 0x01
#define DEBUG_DRIVER  0x02
#define DEBUG_EVENTS  0x04
#define DEBUG_SUBPROC 0x08
#define DEBUG_VIDEO   0x10
#define DEBUG_FRAME   0x20
#define DEBUG_REMOTE  0x40

#define SUPRINTF(x)  ( (G_debug & DEBUG_STARTUP) ? (printf x) : 0 )
#define DRVPRINTF(x) ( (G_debug & DEBUG_DRIVER ) ? (printf x) : 0 )
#define EVPRINTF(x)  ( (G_debug & DEBUG_EVENTS ) ? (printf x) : 0 )
#define SPPRINTF(x)  ( (G_debug & DEBUG_SUBPROC) ? (printf x) : 0 )
#define VDPRINTF(x)  ( (G_debug & DEBUG_VIDEO  ) ? (printf x) : 0 )
#define FRPRINTF(x)  ( (G_debug & DEBUG_FRAME  ) ? (printf x) : 0 )
#define RMPRINTF(x)  ( (G_debug & DEBUG_REMOTE ) ? (printf x) : 0 )

#endif
