/*
 * glob.h
 *
 * Global state definitions for the FXTV video app.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __GLOB_H
#define __GLOB_H

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/XShm.h>
#include "tvtypes.h"
#include "tvscreen.h"
#include "tvcapture.h"
#include "tvaudio.h"
#include "station.h"
#include "annot.h"
#include "audiocnvt.h"
#include "app_rsrc.h"
#include "tvdebug.h"
#include "videolib.h"

typedef enum {
            TV_ICAP_FMT_RGB16,
            TV_ICAP_LAST_RGB = TV_ICAP_FMT_RGB16,
            TV_ICAP_FMT_IYUV,
            TV_ICAP_FMT_YUY2,
            TV_ICAP_FMT_YUY2L
        } TV_ICAP_FMT;

typedef enum {
            TV_STILL_FMT_TIFF,
            TV_STILL_FMT_PPM,
            TV_STILL_FMT_YUV,
            TV_NUM_STILL_FMTS
        } TV_STILL_FMT;

typedef enum {
            TV_VIDEO_TARGET_RAW,
            TV_VIDEO_TARGET_IMAGES,
            TV_VIDEO_TARGET_MPEG_READY,
            TV_VIDEO_TARGET_MPEG,
        } TV_VIDEO_TARGET;

typedef enum {
            TV_TUNER_MODE_ANTENNA,
            TV_TUNER_MODE_CABLE,
            TV_NUM_TUNER_MODES
        } TV_TUNER_MODE;

typedef struct {
    XImage                *ximg;
    TV_GEOM                geom;
    XVisualInfo           *visual;
    TV_BOOL                is_shm;
    XShmSegmentInfo        shm_info;
} TV_XIMAGE;

typedef struct {
    TV_BOOL                enabled;
    TV_BOOL                zoom_on;
    TV_BOOL                freeze_on;
    TV_BOOL                aspect_lock;
    TV_CAPTURE_MODE        cap_mode;
    TV_GEOM                geom;             /*  Video win geom (root rel)  */
    TV_GEOM                refresh_geom;     /*  Refresh geom (root rel)    */
    struct {
        TV_GEOM            geom;
        int                mode;
        int                viewp_x;
        int                viewp_y;
    } unzoomed;

    TV_PIXEL_GEOM          pix_geom;

    TV_IMAGE               image;                   /*  Last frozen image  */

    VL_COLORMAP           *colormap;
    
    XtAppContext           app_context;
    Widget                 shell_wgt;

    Widget                 video_wgt;
    Window                 win;
    TV_BOOL                win_visibility;      /*  X Visibility state  */

    TV_XIMAGE              ximage;
    TV_BOOL                ximage_use_for_expose;
    GC                     gc;                      /* GC for video display  */
    TV_BOOL                waiting_for_resize;

    TV_ANNOT               annot;

    TV_BOOL                cursor_dozeoff_enabled;
    XtIntervalId           cursor_timer;
    TV_BOOL                cursor_timer_set;

} TV_DISPLAY;

typedef struct {
    TV_STATION   *cable_station;
    TV_STATION   *ant_station;
    TV_INT32      cable_num_stations;
    TV_INT32      ant_num_stations;

    TV_FREQ_SET   ant_freq_set;
    TV_FREQ_SET   cable_freq_set;

    TV_TUNER_MODE tuner_mode;
    TV_BOOL       afc_mode;

    TV_BOOL       last_station_is_chan;
    TV_INT32      last_chan;
    double        last_freq;

} TV_PREFS;

typedef struct {
    TV_BOOL             contin_save;
    char                fn_freeze_base[ MAXPATHLEN ];
    char                fn_video_base[ MAXPATHLEN ];
    char                fn_audio_base[ MAXPATHLEN ];
    TV_STILL_FMT        freeze_fmt;
    TV_BOOL             freeze_use_suffix;
    TV_INT32            freeze_next_suffix;
    struct {
        TV_AUDIO_FILE_FMT     file_fmt;
        TV_AUDIO_SAMPLE_FMT   sample_fmt;
        TV_BOOL               stereo;
        TV_UINT32             sample_rate;
    } audio;
    struct {
        TV_BOOL             capture_on;
        TV_ICAP_FMT         icap_fmt;
        TV_VIDEO_TARGET     target;
        TV_GEOM             geom;
        TV_UINT32           fps;
        TV_BOOL             cleanup_temp;
        TV_BOOL             cap_audio;
    } video;
} TV_DISK;


typedef struct {

    TV_CAPTURE  capture;
    TV_XSCREEN  x;
    TV_DISPLAY  display;
    TV_PREFS    prefs;
    TV_DISK     disk;
    TV_AUDIO    audio;

    struct {
        char              queue_name[ 80 ];
    } printer;

} TV_GLOB;

extern TV_GLOB G_glob;
extern TV_BOOL G_in_x_error;

#define TVDISPLAY  G_glob.x.display
#define TVSCREEN   G_glob.x.screen
#define TVAPPCTX   G_glob.display.app_context
#define TVTOPLEVEL G_glob.display.shell_wgt

#ifdef __cplusplus
extern "C" {
#endif

void TVGLOBInit( Display *display, int screen, Widget shell );

void TVSetWorkProcTimeout( TV_INT32 delay_ms );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
