/*
 * audiocnvt.c
 *
 * API to convert RAW audio to/from various audio formats
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __AUDIOCNVT_H
#define __AUDIOCNVT_H

#include "tvaudio.h"
#include "xutil.h"

typedef enum {
            TV_AUDIO_FILE_FMT_RAW,
            TV_AUDIO_FILE_FMT_SUNAU,
            TV_AUDIO_FILE_FMT_WAV,
            TV_AUDIO_FILE_FMT_VOC,
            TV_AUDIO_FILE_FMT_AIFF,
            TV_AUDIO_FILE_FMT_MPEG2,
            TV_AUDIO_FILE_FMT_MPEG3,
            TV_NUM_AUDIO_FILE_FMTS
        } TV_AUDIO_FILE_FMT;

typedef struct {
            TV_AUDIO_FILE_FMT   file_fmt;
            TV_AUDIO_SAMPLE_FMT samp_fmt;
            TV_BOOL             stereo;
            TV_UINT32           samp_rate;
        } TV_SOUND_FMT;



#ifdef __cplusplus
extern "C" {
#endif

void TVAUDIOCNVTBuildSoundFmtSoxArgs(
                TV_SOUND_FMT *fmt,
                char          args[] );

void TVAUDIOCNVTConvertFormat( 
            int                    in_fd,
            char                   in_fname[],
            TV_SOUND_FMT          *in_fmt,
            int                    out_fd,
            char                   out_fname[],
            TV_SOUND_FMT          *out_fmt,
            XUTIL_RUNCMD_CANCELCB *cancel_test,
            void                  *cancel_cb_data,
            XUTIL_RUNCMD_DONECB   *done_cb,
            void                  *done_cb_data );

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif

