/*
 * tvtypes.h
 *
 * Basic types used in the TV app.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVTYPES_H
#define __TVTYPES_H

#include <sys/param.h>
#include <math.h>
#include <string.h>

typedef unsigned char  TV_UINT8;
typedef signed   char  TV_INT8;
typedef unsigned short TV_UINT16;
typedef short          TV_INT16;
typedef unsigned long  TV_UINT32;
typedef long           TV_INT32;

typedef TV_INT32       TV_BOOL;

typedef struct {
            TV_INT32 x,y,w,h;
        } TV_GEOM;

typedef enum {
    TV_TRANSFER_STD_IMAGE    = 0x1,
    TV_TRANSFER_SHMEM_IMAGE  = 0x2,
    TV_TRANSFER_SHMEM_PIXMAP = 0x4,
    TV_TRANSFER_DIRECT       = 0x8
} TV_TRANSFER_MODE;

#define DOUBLE_EPS 1e-7
#define FLOAT_EPS  1e-4

#define APPROX(x,y,e)    (fabs( (x)-(y) ) < (e))
#define INRANGE(x,a,b,e) ( ((x) >= (a)-(e)) && ((x) <= (b)+(e)) )

#define SHIFT_AND_MASK(val,lshf,msk)                     \
           (((lshf) >= 0) ? (((val) <<  (lshf)) & (msk)) \
                          : (((val) >> -(lshf)) & (msk)))

#ifndef MIN
#  define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif
#ifndef MAX
#  define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif

#define STREQ(a,b) (strcmp((a),(b)) == 0)

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
