/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: filePropDialog.cpp,v 1.4 2004/12/20 08:04:06 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "fwbuilder/FWObjectDatabase.h"

#include "filePropDialog.h"
#include "FWWindow.h"

#include "RCS.h"

#include <qlabel.h>
#include <qtextbrowser.h>

#include <time.h>

#ifndef _WIN32
#  include <unistd.h>     // for access(2)
#endif


#include <iostream>

using namespace std;

    
filePropDialog::filePropDialog(QWidget *parent, RCS *rcs) :
    filePropDialog_q(parent) 
{
    fileLocation->setText( rcs->getFileName() );
    if (rcs->isRO()) fileRO->setText( tr("Opened read-only") );
    else             fileRO->setText("");

    time_t lm = mw->db()->getTimeLastModified();
    QString s = ctime( &lm );
    s.truncate( s.length()-1 );   // chop newline 

    lastModified->setText( QString("%1 (%2)").arg(s).arg(lm) );

    if (rcs->isInRCS())
    {
        fileRev->setText( rcs->getSelectedRev() );
        fileLockedBy->setText( rcs->getLockedBy() );

        QValueList<Revision>::iterator i;
        for (i=rcs->begin(); i!=rcs->end(); ++i)
        {
            Revision r= *i;
            fileRevHistory->append( tr("Revision %1").arg(r.rev) );
            fileRevHistory->append( r.log );
            fileRevHistory->append("\n");
            fileRevHistory->setCursorPosition(0,0);
        }
    } else
    {
        fileRev->setText("");
        fileLockedBy->setText("");
        fileRevHistory->setText("");
    }
}
