/* utils.c: useful utility functions
   Copyright (c) 2002-2003 Philip Kendall

   $Id: utils.h,v 1.4 2003/10/13 15:42:26 pak21 Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

#ifndef FUSE_UTILS_UTILS_H
#define FUSE_UTILS_UTILS_H

#include <libspectrum.h>

int init_libspectrum( void );
int get_creator( libspectrum_creator **creator, const char *program );
int mmap_file( const char *filename, unsigned char **buffer, size_t *length );

struct rzx_key {
  libspectrum_dword id;
  const char *description;
  libspectrum_rzx_dsa_key key;
};

extern struct rzx_key known_keys[];

#endif				/* #ifndef FUSE_UTILS_UTILS_H */
