/* options.c: options dialog boxes
   Copyright (c) 2001-2002 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#include "display.h"
#include "options.h"
#include "ui/uidisplay.h"
static int widget_general_show_all( settings_info *show );

int widget_general_draw( void *data )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) return error;

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 4 );
  error = widget_general_show_all( &widget_options_settings );
  if( error ) return error;

  uidisplay_lines( DISPLAY_BORDER_HEIGHT + 16,
		   DISPLAY_BORDER_HEIGHT + 32 + 4 * 8 );

  return 0;
}

static int widget_general_show_all( settings_info *show )
{
  int error;

  widget_printstring( 9, 2, WIDGET_COLOUR_FOREGROUND, "General Options" );

  error = widget_options_print_option( 0, "Issue (2) Keyboard",
				       show->issue2 );
  if( error ) return error;

  error = widget_options_print_option( 1, "(K)empston joystick",
				       show->joy_kempston );
  if( error ) return error;

  error = widget_options_print_option( 2, "Use (t)ape traps",
				       show->tape_traps );
  if( error ) return error;

  error = widget_options_print_option( 3, "Use .(s)lt traps",
				       show->slt_traps );
  if( error ) return error;

  return 0;
}

void widget_general_keyhandler( keyboard_key_name key )
{
  int error;

  switch( key ) {
    
  case KEYBOARD_1: /* 1 used as `Escape' generates `Edit', which is Caps + 1 */
    widget_return[ widget_level ].finished = WIDGET_FINISHED_CANCEL;
    break;

  case KEYBOARD_2:
    widget_options_settings.issue2 = ! widget_options_settings.issue2;
    error = widget_options_print_value( 0, widget_options_settings.issue2 );
    if( error ) return;
    break;

  case KEYBOARD_k:
    widget_options_settings.joy_kempston = ! widget_options_settings.joy_kempston;
    error = widget_options_print_value( 1, widget_options_settings.joy_kempston );
    if( error ) return;
    break;

  case KEYBOARD_t:
    widget_options_settings.tape_traps = ! widget_options_settings.tape_traps;
    error = widget_options_print_value( 2, widget_options_settings.tape_traps );
    if( error ) return;
    break;

  case KEYBOARD_s:
    widget_options_settings.slt_traps = ! widget_options_settings.slt_traps;
    error = widget_options_print_value( 3, widget_options_settings.slt_traps );
    if( error ) return;
    break;

  case KEYBOARD_Enter:
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_sound_show_all( settings_info *show );

int widget_sound_draw( void *data )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) return error;

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 3 );
  error = widget_sound_show_all( &widget_options_settings );
  if( error ) return error;

  uidisplay_lines( DISPLAY_BORDER_HEIGHT + 16,
		   DISPLAY_BORDER_HEIGHT + 32 + 3 * 8 );

  return 0;
}

static int widget_sound_show_all( settings_info *show )
{
  int error;

  widget_printstring( 10, 2, WIDGET_COLOUR_FOREGROUND, "Sound Options" );

  error = widget_options_print_option( 0, "(S)ound enabled",
				       show->sound );
  if( error ) return error;

  error = widget_options_print_option( 1, "(L)oading sound",
				       show->sound_load );
  if( error ) return error;

  error = widget_options_print_option( 2, "(A)Y stereo separation",
				       show->stereo_ay );
  if( error ) return error;

  return 0;
}

void widget_sound_keyhandler( keyboard_key_name key )
{
  int error;

  switch( key ) {
    
  case KEYBOARD_1: /* 1 used as `Escape' generates `Edit', which is Caps + 1 */
    widget_return[ widget_level ].finished = WIDGET_FINISHED_CANCEL;
    break;

  case KEYBOARD_s:
    widget_options_settings.sound = ! widget_options_settings.sound;
    error = widget_options_print_value( 0, widget_options_settings.sound );
    if( error ) return;
    break;

  case KEYBOARD_l:
    widget_options_settings.sound_load = ! widget_options_settings.sound_load;
    error = widget_options_print_value( 1, widget_options_settings.sound_load );
    if( error ) return;
    break;

  case KEYBOARD_a:
    widget_options_settings.stereo_ay = ! widget_options_settings.stereo_ay;
    error = widget_options_print_value( 2, widget_options_settings.stereo_ay );
    if( error ) return;
    break;

  case KEYBOARD_Enter:
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
