#!/usr/bin/perl -w

# options-header.pl: generate options dialog boxes
# $Id: options-header.pl,v 1.4 2002/02/26 10:26:08 pak21 Exp $

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

# Author contact information:

# E-mail: pak21-fuse@srcf.ucam.org
# Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

use strict;

use lib '../../perl';

use Fuse;
use Fuse::Dialog;

die "No data file specified" unless @ARGV;

my @dialogs = Fuse::Dialog::read( shift @ARGV );

print Fuse::GPL( 'options.h: options dialog boxes',
		 '2001-2002 Philip Kendall' ) . << "CODE";

/* This file is autogenerated from options.dat by options-header.pl.
   Do not edit unless you know what you\'re doing! */

#ifndef FUSE_GTKOPTIONS_H
#define FUSE_GTKOPTIONS_H

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif

CODE

foreach( @dialogs ) {

    print << "CODE";
void gtkoptions_$_->{name}( GtkWidget *widget, gpointer data );

typedef struct gtkoptions_$_->{name}_t \{

  GtkWidget *dialog;

CODE

    foreach my $widget ( @{ $_->{widgets} } ) {

	if( $widget->{type} eq "Checkbox" ) {
	    print "  GtkWidget *$widget->{value};\n";
	}

    }

    print "\n} gtkoptions_$_->{name}_t;\n\n"
}

print << "CODE";
#endif				/* #ifndef FUSE_GTKOPTIONS_H */
CODE
