#ifndef _IPMI_UDM_DEVICE_H
#define _IPMI_UDM_DEVICE_H

#include <sys/time.h>
#include <stdint.h>
#include <netinet/in.h>

#include "freeipmi/fiid.h"
#include "freeipmi/ipmi-kcs-api.h"
#include "freeipmi/ipmi-locate.h"
#include "freeipmi/ipmi-openipmi-api.h"
#include "freeipmi/ipmi-ssif-api.h"

#include "freeipmi/udm/ipmi-udm.h"

#define IPMI_UDM_DEVICE_MAGIC 0xfafab0b0

enum ipmi_lan_session_state
  {
    IPMI_LAN_SESSION_STATE_GET_CHANNEL_AUTHENTICAPTION_CAPABILITIES = 0,
    IPMI_LAN_SESSION_STATE_GET_SESSION_CHALLENGE = 1,
    IPMI_LAN_SESSION_STATE_ACTIVATE_SESSION = 2,
    IPMI_LAN_SESSION_STATE_SET_SESSION_PRIVILEGE_LEVEL = 3,
    IPMI_LAN_SESSION_STATE_IN_SESSION = 4,
    IPMI_LAN_SESSION_STATE_CLOSE_SESSION = 5,
  };

struct ipmi_device
{
  uint32_t           magic;

  ipmi_driver_type_t type;
  uint32_t           flags;
  uint8_t            lun;
  uint8_t            net_fn;
  ipmi_errnum_type_t errnum;

  union
  {
    struct
    {
      ipmi_kcs_ctx_t          kcs_ctx;
      ipmi_ssif_ctx_t         ssif_ctx;
      ipmi_openipmi_ctx_t     openipmi_ctx;

      struct
      {
        fiid_obj_t      obj_hdr;
      } rq;

      struct
      {
        fiid_obj_t      obj_hdr;
      } rs;
    } inband;

    struct
    {
      int                local_sockfd;
      struct sockaddr_in remote_host;

      uint8_t           authentication_type;
      uint8_t           challenge_string[IPMI_CHALLENGE_STRING_LENGTH];
      uint32_t          session_id;
      uint32_t          session_sequence_number;
      uint8_t           rq_seq;

      uint8_t           username[IPMI_MAX_USER_NAME_LENGTH];
      uint8_t           password[IPMI_MAX_AUTHENTICATION_CODE_LENGTH];
      uint8_t           privilege_level;

      unsigned int      session_timeout;
      unsigned int      retry_timeout;
      unsigned int      retry_count;
      struct timeval    last_send;
      struct timeval    last_received;

      /* achu: per_msg_auth is backwards for some reason
       *
       * 0 = enabled
       * 1 = disabled
       */
      uint8_t           per_msg_auth_disabled;

      unsigned int      lan_session_state;
      
      struct
      {
        fiid_obj_t      obj_rmcp_hdr;
        fiid_obj_t      obj_lan_session_hdr;
        fiid_obj_t      obj_lan_msg_hdr;
      } rq;

      struct
      {
        fiid_obj_t      obj_rmcp_hdr;
        fiid_obj_t      obj_lan_session_hdr;
        fiid_obj_t      obj_lan_msg_hdr;
        fiid_obj_t      obj_lan_msg_trlr;
      } rs;
    } outofband;
  } io;
};

#endif /* _IPMI_UDM_DEVICE_H */
