/* 
   fiid-wrappers.h - FreeIPMI Interface Definition wrappers

   Copyright (C) 2003, 2004, 2005 FreeIPMI Core Team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  

*/

#ifndef _UDM_FIID_WRAPPERS_H
#define	_UDM_FIID_WRAPPERS_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>

#include "freeipmi/fiid.h"

#include "err-wrappers.h"
#include "fiid-wrappers.h"

#define __FIID_OBJ_SET_UDM_ERRNUM(___obj)          \
do {                                               \
  int32_t __errnum = fiid_obj_errnum((___obj));    \
  if (__errnum == FIID_ERR_SUCCESS)                \
    dev->errnum = IPMI_ERR_SUCCESS;                \
  else if (__errnum == FIID_ERR_OUTMEM)            \
    dev->errnum = IPMI_ERR_OUT_OF_MEMORY;          \
  else                                             \
    dev->errnum = IPMI_ERR_INTERNAL_LIBRARY_ERROR; \
} while (0)

#define UDM_FIID_TEMPLATE_LEN_BYTES(__len, __tmpl)          \
do {                                                        \
  if (((__len) = fiid_template_len_bytes ((__tmpl))) < 0)   \
    {                                                       \
      __FIID_SYSLOG;                                        \
      __FIID_TRACE;                                         \
      __ERRNO_TO_UDM_ERRNUM;                                \
      return (-1);                                          \
    }                                                       \
} while (0)

#define UDM_FIID_TEMPLATE_LEN_BYTES_CLEANUP(__len, __tmpl)  \
do {                                                        \
  if (((__len) = fiid_template_len_bytes ((__tmpl))) < 0)   \
    {                                                       \
      __FIID_SYSLOG;                                        \
      __FIID_TRACE;                                         \
      __ERRNO_TO_UDM_ERRNUM;                                \
      goto cleanup;                                         \
    }                                                       \
} while (0)

#define UDM_FIID_TEMPLATE_FREE_NO_RETURN(__tmpl)   FIID_TEMPLATE_FREE_NO_RETURN(__tmpl)

#define UDM_FIID_OBJ_CREATE(__obj, __tmpl)          \
do {                                                \
  if (!((__obj) = fiid_obj_create(__tmpl)))         \
    {                                               \
      __FIID_SYSLOG;                                \
      __FIID_TRACE;                                 \
      dev->errnum = IPMI_ERR_OUT_OF_MEMORY;         \
      return (-1);                                  \
    }                                               \
} while (0)

#define UDM_FIID_OBJ_CREATE_CLEANUP(__obj, __tmpl)  \
do {                                                \
  if (!((__obj) = fiid_obj_create(__tmpl)))         \
    {                                               \
      __FIID_SYSLOG;                                \
      __FIID_TRACE;                                 \
      dev->errnum = IPMI_ERR_OUT_OF_MEMORY;         \
      goto cleanup;                                 \
    }                                               \
} while (0)

#define UDM_FIID_OBJ_DESTROY(__obj) FIID_OBJ_DESTROY(__obj)

#define UDM_FIID_OBJ_LEN_BYTES(__len, __obj)             \
do {                                                     \
    if (((__len) = fiid_obj_len_bytes ((__obj))) < 0)    \
      {                                                  \
         __FIID_OBJ_SYSLOG((__obj));                     \
         __FIID_OBJ_TRACE((__obj));                      \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));             \
         return (-1);                                    \
      }                                                  \
} while (0)

#define UDM_FIID_OBJ_LEN_BYTES_CLEANUP(__len, __obj)     \
do {                                                     \
    if (((__len) = fiid_obj_len_bytes ((__obj))) < 0)    \
      {                                                  \
         __FIID_OBJ_SYSLOG((__obj));                     \
         __FIID_OBJ_TRACE((__obj));                      \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));             \
         goto cleanup;                                   \
      }                                                  \
} while (0)

#define UDM_FIID_OBJ_CLEAR(__obj)                        \
do {                                                     \
    if (fiid_obj_clear ((__obj)) < 0)                    \
      {                                                  \
         __FIID_OBJ_SYSLOG((__obj));                     \
         __FIID_OBJ_TRACE((__obj));                      \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));             \
         return (-1);                                    \
      }                                                  \
} while (0)

#define UDM_FIID_OBJ_SET_ALL(__obj, __data, __data_len)                     \
do {                                                                        \
    if (fiid_obj_set_all ((__obj), (__data), (__data_len)) < 0)             \
      {                                                                     \
         __FIID_OBJ_SYSLOG((__obj));                                        \
         __FIID_OBJ_TRACE((__obj));                                         \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                \
         return (-1);                                                       \
      }                                                                     \
} while (0)

#define UDM_FIID_OBJ_SET_ALL_CLEANUP(__obj, __data, __data_len)             \
do {                                                                        \
    if (fiid_obj_set_all ((__obj), (__data), (__data_len)) < 0)             \
      {                                                                     \
         __FIID_OBJ_SYSLOG((__obj));                                        \
         __FIID_OBJ_TRACE((__obj));                                         \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                \
         goto cleanup;                                                      \
      }                                                                     \
} while (0)

#define UDM_FIID_OBJ_GET(__obj, __field, __val)               \
do {                                                          \
    uint64_t __localval = 0, *__localval_ptr;                 \
    __localval_ptr = (__val);                                 \
    if (fiid_obj_get ((__obj), (__field), &__localval) < 0)   \
      {                                                       \
         __FIID_OBJ_SYSLOG((__obj));                          \
         __FIID_OBJ_TRACE((__obj));                           \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                  \
         return (-1);                                         \
      }                                                       \
    *__localval_ptr = __localval;                             \
} while (0)

#define UDM_FIID_OBJ_GET_CLEANUP(__obj, __field, __val)       \
do {                                                          \
    uint64_t __localval = 0, *__localval_ptr;                 \
    __localval_ptr = (__val);                                 \
    if (fiid_obj_get ((__obj), (__field), &__localval) < 0)   \
      {                                                       \
         __FIID_OBJ_SYSLOG((__obj));                          \
         __FIID_OBJ_TRACE((__obj));                           \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                  \
         goto cleanup;                                        \
      }                                                       \
    *__localval_ptr = __localval;                             \
} while (0)

#define UDM_FIID_OBJ_GET_DATA(__obj, __field, __data, __data_len)            \
do {                                                                         \
    if (fiid_obj_get_data ((__obj), (__field), (__data), (__data_len)) < 0)  \
      {                                                                      \
         __FIID_OBJ_SYSLOG((__obj));                                         \
         __FIID_OBJ_TRACE((__obj));                                          \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                 \
         return (-1);                                                        \
      }                                                                      \
} while (0)

#define UDM_FIID_OBJ_GET_DATA_CLEANUP(__obj, __field, __data, __data_len)    \
do {                                                                         \
    if (fiid_obj_get_data ((__obj), (__field), (__data), (__data_len)) < 0)  \
      {                                                                      \
         __FIID_OBJ_SYSLOG((__obj));                                         \
         __FIID_OBJ_TRACE((__obj));                                          \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                 \
         goto cleanup;                                                       \
      }                                                                      \
} while (0)

#define UDM_FIID_OBJ_GET_ALL(__obj, __data, __data_len)                      \
do {                                                                         \
    if (fiid_obj_get_all ((__obj), (__data), (__data_len)) < 0)              \
      {                                                                      \
         __FIID_OBJ_SYSLOG((__obj));                                         \
         __FIID_OBJ_TRACE((__obj));                                          \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                 \
         return (-1);                                                        \
      }                                                                      \
} while (0)

#define UDM_FIID_OBJ_GET_ALL_CLEANUP(__obj, __data, __data_len)              \
do {                                                                         \
    if (fiid_obj_get_all ((__obj), (__data), (__data_len)) < 0)              \
      {                                                                      \
         __FIID_OBJ_SYSLOG((__obj));                                         \
         __FIID_OBJ_TRACE((__obj));                                          \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                 \
         goto cleanup;                                                       \
      }                                                                      \
} while (0)

#define UDM_FIID_OBJ_GET_ALL_LEN(__len, __obj, __data, __data_len)          \
do {                                                                        \
    if (((__len) = fiid_obj_get_all ((__obj), (__data), (__data_len))) < 0) \
      {                                                                     \
         __FIID_OBJ_SYSLOG((__obj));                                        \
         __FIID_OBJ_TRACE((__obj));                                         \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                \
         return (-1);                                                       \
      }                                                                     \
} while (0)

#define UDM_FIID_OBJ_GET_ALL_LEN_CLEANUP(__len, __obj, __data, __data_len)  \
do {                                                                        \
    if (((__len) = fiid_obj_get_all ((__obj), (__data), (__data_len))) < 0) \
      {                                                                     \
         __FIID_OBJ_SYSLOG((__obj));                                        \
         __FIID_OBJ_TRACE((__obj));                                         \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                                \
         goto cleanup;                                                      \
      }                                                                     \
} while (0)

#define UDM_FIID_OBJ_PACKET_VALID(__obj)               \
do {                                                   \
    int __ret;                                         \
    if ((__ret = fiid_obj_packet_valid((__obj))) < 0)  \
      {                                                \
        __FIID_OBJ_SYSLOG((__obj));                    \
        __FIID_OBJ_TRACE((__obj));                     \
	__FIID_OBJ_SET_UDM_ERRNUM((__obj));            \
        return (-1);                                   \
      }                                                \
    if (!__ret)                                        \
      {                                                \
        __FIID_OBJ_SYSLOG((__obj));                    \
        __FIID_OBJ_TRACE((__obj));                     \
        dev->errnum = IPMI_ERR_INVALID_PARAMETERS;     \
	return (-1);                                   \
      }                                                \
} while (0)

#define UDM_FIID_OBJ_TEMPLATE_CLEANUP(__ptr, __obj)    \
do {                                                   \
    if (!(__ptr = fiid_obj_template((__obj))))         \
      {                                                \
        __FIID_OBJ_SYSLOG((__obj));                    \
        __FIID_OBJ_TRACE((__obj));                     \
	__FIID_OBJ_SET_UDM_ERRNUM((__obj));            \
        goto cleanup;                                  \
      }                                                \
} while (0)

#define UDM_FIID_OBJ_TEMPLATE_COMPARE(__obj, __tmpl)                 \
do {                                                                 \
    int __ret;                                                       \
    if ((__ret = fiid_obj_template_compare ((__obj), (__tmpl))) < 0) \
      {                                                              \
         __FIID_OBJ_SYSLOG((__obj));                                 \
         __FIID_OBJ_TRACE((__obj));                                  \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                         \
         return (-1);                                                \
      }                                                              \
    if (!__ret)                                                      \
      {                                                              \
	errno = EINVAL;                                              \
         __FIID_OBJ_SYSLOG((__obj));                                 \
         __FIID_OBJ_TRACE((__obj));                                  \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                         \
	return (-1);                                                 \
      }                                                              \
} while (0)

#define UDM_FIID_OBJ_TEMPLATE_COMPARE_CLEANUP(__obj, __tmpl)         \
do {                                                                 \
    int __ret;                                                       \
    if ((__ret = fiid_obj_template_compare ((__obj), (__tmpl))) < 0) \
      {                                                              \
         __FIID_OBJ_SYSLOG((__obj));                                 \
         __FIID_OBJ_TRACE((__obj));                                  \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                         \
         goto cleanup;                                               \
      }                                                              \
    if (!__ret)                                                      \
      {                                                              \
	errno = EINVAL;                                              \
         __FIID_OBJ_SYSLOG((__obj));                                 \
         __FIID_OBJ_TRACE((__obj));                                  \
         __FIID_OBJ_SET_UDM_ERRNUM((__obj));                         \
	goto cleanup;                                                \
      }                                                              \
} while (0)

#ifdef __cplusplus
}
#endif

#endif /* udm-fiid-wrappers.h */
