/********************************************************************************
*                                                                               *
*                     T h e   A d i e   T e x t   E d i t o r                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2003 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: Adie.h,v 1.45 2003/09/12 00:55:07 fox Exp $                              *
********************************************************************************/
#ifndef ADIE_H
#define ADIE_H


// Version
#define VERSION_MAJOR 2
#define VERSION_MINOR 0
#define VERSION_PATCH 0

// Styles
#define MAXSTYLES   64

class HelpWindow;
class Preferences;
class TextWindow;


// Main Application class
class Adie : public FXApp {
  FXDECLARE(Adie)
  friend class TextWindow;
protected:
  TextWindowList  windowlist;                   // Window list
  FXFileDict     *associations;                 // File association table
  FXHiliteStyle   stylecolor[MAXSTYLES];        // Text style colors
  FXString        stylename[MAXSTYLES];         // Text style names
  FXint           nstyles;                      // Number of styles
  FXIcon         *bigicon;                      // Big application icon
  FXIcon         *smallicon;                    // Small application icon
  FXIcon         *newicon;
  FXIcon         *reloadicon;
  FXIcon         *openicon;
  FXIcon         *saveicon;
  FXIcon         *saveasicon;
  FXIcon         *printicon;
  FXIcon         *cuticon;
  FXIcon         *copyicon;
  FXIcon         *pasteicon;
  FXIcon         *deleteicon;
  FXIcon         *undoicon;
  FXIcon         *redoicon;
  FXIcon         *fontsicon;
  FXIcon         *helpicon;
  FXIcon         *quiticon;
  FXIcon         *searchicon;
  FXIcon         *searchnexticon;
  FXIcon         *searchprevicon;
  FXIcon         *bookseticon;
  FXIcon         *booknexticon;
  FXIcon         *bookprevicon;
  FXIcon         *bookdelicon;
  FXIcon         *shiftlefticon;
  FXIcon         *shiftrighticon;
private:
  Adie(){}
  Adie(const Adie&);
  Adie& operator=(const Adie&);
public:
  enum{
    ID_CLOSEALL=FXApp::ID_LAST,
    ID_LAST
    };
public:
  long onCmdCloseAll(FXObject*,FXSelector,void*);
public:

  // Construct application object
  Adie(const FXString& name);

  // Initialize application
  virtual void init(int& argc,char** argv,FXbool connect=TRUE);

  // Exit application
  virtual void exit(FXint code=0);

  // Style management
  void readStyles();
  void writeStyles();

  // Return number of styles
  FXint getNumStyles() const { return nstyles; }

  // Delete style
  void deleteStyle(FXint index);

  // Append style
  void appendStyle(const FXString& name,const FXHiliteStyle& style);

  // Get style name
  const FXString& getStyleName(FXint index) const { return stylename[index]; }

  // Change style name
  void setStyleName(FXint index,const FXString& name){ stylename[index]=name; }

  // Get style colors
  const FXHiliteStyle& getStyleColors(FXint index) const { return stylecolor[index]; }

  // Change style colors
  void setStyleColors(FXint index,const FXHiliteStyle& style);

  // Delete application object
  virtual ~Adie();
  };

#endif

