//
// File: <vars.inc>
//
// Written by: David M. Stanhope [voip@fobbit.com]
//
// routines to build and parse messages
//
// TODO:
//    1> will break badly if '|' in any strings sending back and forth
//       so need to add ability to escape '|' if in the value
//

#include "vblast.h"

// ---------------------------------------------------------------------------

// routine to add a string variable entry to a message
void
var_add_str(char *p, char *name, char *value)
{
    static char *s;

    if(value == NULL) return; // do not bother to add if empty

    if(p)
    {
        s = p;
    }
    else
    {
        *s++ = '|';
    }

    sprintf(s, "%s=%s", name, value);

    s += strlen(s);
}

// like above but takes an integer
void
var_add_int(char *p, char *name, int value)
{
    char buf[16];

    sprintf(buf, "%d", value);

    var_add_str(p, name, buf);
}

// like above but takes an long integer
void
var_add_i32(char *p, char *name, long value)
{
    char buf[16];

    sprintf(buf, "%ld", value);

    var_add_str(p, name, buf);
}

// ---------------------------------------------------------------------------

static char *_var_name [64];
static char *_var_value[64];
static int   _var_count    ;

void
var_parse(char *msg)
{
    static char buf[BIG_BUF_SIZE]; char *p = buf;

    strcpy(p, msg); // make local copy since caller may still need original

    _var_count = 0; // clear for new parse

    while(*p != '\0')                        // loop for each variable
    {                                        //
        _var_name[_var_count] = p;           // assume start of variable name
        while(*p != '\0')                    // find end of the variable name
        {                                    //
            if(*p != '=') { p++; continue; } // keep scanning for '='
            *p++ = '\0';                     // terminate variable name string
            _var_value[_var_count] = p;      // assume start of variable value
            while(1)                         // find end of the variable value
            {                                //
                if(*p == '|')                // have found end of value
                {                            //
                    *p++ = '\0';             // terminate variable value string
                    _var_count++;            // essentially add it to list
                    break;                   // go do next variable
                }                            //
                else if(*p == '\0')          // it is last variable in message
                {                            //
                    _var_count++;            // essentially add it to list
                    break;                   // all done
                }                            //
                else                         //
                {                            //
                    p++;                     // still looking for end of value
                }                            //
            }                                //
            break;                           // go do next variable
        }
    }
}

// ---------------------------------------------------------------------------

char *
var_find(char *name)
{
    int i;
    for(i = 0; i < _var_count; i++)
    {
        if(strcmp(_var_name[i], name) == 0) return _var_value[i];
    }

    return NULL; // not found
}

// special case that only checks first entry, used as message type
char *
var0_chk(char *name)
{
    if(strcmp(_var_name[0], name) == 0) return _var_value[0];
    return NULL; // not found
}

// ---------------------------------------------------------------------------

//
// The End!
//
