//
// File: <cvt.c>
//
// Written by: David M. Stanhope [voip@fobbit.com]
//
// Simple program to take an arbitary file and convert it to a
// a structure in a 'C' source file.
//

#include <stdio.h>

#define NAME_PROGRAM argv[0]
#define NAME_INPUT   argv[1]
#define NAME_OUTPUT  argv[2]
#define NAME_ENTRY   argv[3]

main(int argc, char *argv[])
{
    FILE *i_fp, *o_fp; int r, i, c, n = 0; unsigned char rbuf[512];

    if(argc != 4)
        {
        fprintf(stderr, "Usage: %s input_file output_file entry_name\n",
                                                          NAME_PROGRAM);
        exit(1);
        }

    if((i_fp = fopen(NAME_INPUT, "rb")) == NULL)
        {
        fprintf(stderr, "Can't open <%s> for input!\n", NAME_INPUT);
        exit(1);
        }

    if((o_fp = fopen(NAME_OUTPUT, "w")) == NULL)
        {
        fprintf(stderr, "Can't open <%s> for output!\n", NAME_OUTPUT);
        exit(1);
        }

    fprintf(o_fp, "//\n");
    fprintf(o_fp, "// File: <%s>\n", NAME_OUTPUT);
    fprintf(o_fp, "//\n");
    fprintf(o_fp, "// Automatically Generated File, Do Not Edit!\n");
    fprintf(o_fp, "//\n");
    fprintf(o_fp, "//\n");
    fprintf(o_fp, "\n");
    fprintf(o_fp, "unsigned char %s_data[] =\n", NAME_ENTRY);
    fprintf(o_fp, "    {\n");

    while((r = fread(rbuf, 1, sizeof(rbuf), i_fp)) > 0)
        {
        for(c = 0, i = 0; i < r; i++, c++)
            {
            if(c == 8) { fprintf(o_fp,  "\n"); c = 0; }
            if(c == 0) { fprintf(o_fp, "   ");        }
            fprintf(o_fp, " 0x%02x,", rbuf[i]); n++;
            }
        fprintf(o_fp, "\n");
        }

    fprintf(o_fp, "    };\n\n");

    fprintf(o_fp, "int %s_size = %d;\n\n", NAME_ENTRY, n);

    fprintf(o_fp, "//\n"         );
    fprintf(o_fp, "// The End!\n");
    fprintf(o_fp, "//\n"         );

    fclose(i_fp);
    fclose(o_fp);

    exit(0);
}

//
// The End!
//
