// Workspace.hh for Fluxbox
// Copyright (c) 2002 Henrik Kinnunen (fluxgen@linuxmail.org)
//
// Workspace.hh for Blackbox - an X11 Window manager
// Copyright (c) 1997 - 2000 Brad Hughes (bhughes@tcac.net)
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef	 WORKSPACE_HH
#define	 WORKSPACE_HH

#include "Window.hh"

#include <X11/Xlib.h>
#include <string>
#include <vector>
#include <list>

class BScreen;
class Clientmenu;
class Workspace;



class Workspace {
public:
	typedef std::vector<FluxboxWindow *> Windows;
	
	Workspace(BScreen *screen, unsigned int workspaceid= 0);
	~Workspace(void);

	inline BScreen *getScreen(void) const { return screen; }
	inline FluxboxWindow *getLastFocusedWindow(void) const { return lastfocus; }	
	inline Clientmenu *menu(void) const { return clientmenu; }
	inline const std::string &name(void) const { return m_name; }
	inline const unsigned int workspaceID(void) const { return m_id; }	
	inline void setLastFocusedWindow(FluxboxWindow *w) { lastfocus = w; }
	FluxboxWindow *getWindow(unsigned int id) const;
	inline Windows &getWindowList() { return windowList; }
	bool isCurrent(void) const;
	bool isLastWindow(FluxboxWindow *window) const;	
	const int addWindow(FluxboxWindow *window, bool place = false);
	const int removeWindow(FluxboxWindow *);
	const int getCount(void) const;
	void setName(const char *name);
	void showAll(void);
	void hideAll(void);
	void removeAll(void);
	void raiseWindow(FluxboxWindow *);
	void lowerWindow(FluxboxWindow *);
	void reconfigure();
	void update();
	void setCurrent(void);
	void shutdown(void);

private:
	BScreen *screen;
	FluxboxWindow *lastfocus;
	Clientmenu *clientmenu;

	typedef std::list<FluxboxWindow *> WindowStack;
 

	WindowStack stackingList;
	Windows windowList;

	std::string m_name;
	unsigned int m_id;
	int cascade_x, cascade_y;


protected:
	void placeWindow(FluxboxWindow *);
};


#endif // _WORKSPACE_HH_

