# -*- mode:perl -*-
# $Id: Makefile.PL,v 1.8 2001/05/18 22:55:37 dplonka Exp $

require 5.003; # for INSTALLSCRIPT

# use Config;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    # ABSTRACT_FROM  => 'Cflow.pm',
    # AUTHOR         => 'Dave Plonka <plonka@doit.wisc.edu>',
    CONFIGURE      => \&find_flow_tools,
    EXE_FILES      => [ 'flowdumper' ],
    NAME           => 'Cflow',
    PM             => {
			 'Cflow.pm' => '$(INST_LIBDIR)/Cflow.pm',
		      },
    VERSION_FROM   => 'Cflow.pm', # finds $VERSION
    clean          => { FILES => '$(EXE_FILES)' },
    dist           => {
                         'COMPRESS' =>  'gzip',
                         'SUFFIX' => 'gz',
                      },
);

sub find_flow_tools {
   my($ver, $dir);
   my($libdir, $incdir);
   if (-f '../../lib/libft.a') {
      $dir = '../../lib';
      $incdir = "-I$dir -I$dir/..";
      $libdir = "-L$dir";
   }
   if ("$libdir") {
      print "Found flow-tools... using \"-DOSU $incdir $libdir -lft -lz\".\n";
      return { CCFLAGS => '-DOSU',
	       INC     => join(' ', $incdir),
	       LIBS    => [ join(' ', $libdir, '-lnsl -lft -lz') ] }
   }
   # flow-tools not found... cflowd support only.
   return { INC     => join(' ', $incdir),
	    LIBS    => [ join(' ', $libdir, '-lnsl') ] }
}
