#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#if 0 /* This is now the responsibility of Makefile.PL */
#define OSU
#endif

#include <errno.h> /* errno, ENOENT */
#include <fcntl.h> /* fcntl, open, O_RDONLY */
#include <limits.h> /* PATH_MAX */
#include <stdio.h> /* FILE, stderr, fdopen, fread, fclose, sprintf */
#include <string.h> /* strncpy, strcmp, strerror, memcpy */
#include <sys/types.h> /* size_t */
#include <unistd.h> /* STDIN_FILENO, close */

#include "cflow5.h"

#ifdef OSU /* { */

/* { kludge since flow-tools config.h macros collide with perl's/xsubpp's */
#  define SAVE_PACKAGE PACKAGE
#  undef PACKAGE
#  define SAVE_VERSION VERSION
#  undef VERSION
/* } */

#  include "config.h"
#  include "ftlib.h"

/* { kludge revisited */
#  undef PACKAGE
#  undef VERSION
#  define PACKAGE SAVE_PACKAGE
#  define VERSION SAVE_VERSION
/* } */

#endif /* } */


/*
 * This is the value for index that we *expect* using Cisco flow-export
 * version 5 and cflowd-2.x.  This was determined by simple experimentation
 * with just "COLLECT: { flows }" in "cflowd.conf".
 */
uint32_t expected_entry_mask =
   k_routerMask |
   k_srcIpAddrMask |
   k_dstIpAddrMask |
   k_inputIfIndexMask |
   k_outputIfIndexMask |
   k_srcPortMask |
   k_dstPortMask |
   k_pktsMask |
   k_bytesMask |
   k_ipNextHopMask |
   k_startTimeMask |
   k_endTimeMask |
   k_protocolMask |
   k_tosMask |
   k_srcAsMask |
   k_dstAsMask |
   k_srcMaskLenMask |
   k_dstMaskLenMask |
   k_tcpFlagsMask |
   k_engineTypeMask |
   k_engineIdMask;

static int
not_here(s)
char *s;
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant(name, arg)
char *name;
int arg;
{
    errno = 0;
    switch (*name) {
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

MODULE = Cflow		PACKAGE = Cflow		

PROTOTYPES: ENABLE

char *
find(wanted, ...)
	SV* wanted
	PREINIT:
		size_t arg = 1; /* current argument */
		size_t n = 0; /* return value (number of flows matched) */
		size_t total = 0; /* return value (total number of flows) */
		char retval[sizeof "4294967295/4294967295"]; /* UINT_MAX */
		SV *perfile = (SV *)0;
		unsigned verbose;
#            ifdef OSU /* { */
                struct ftio fs;
                struct fts3rec_gen *fdata;
                /* f5data is just a casted (sic) alias for fdata: */
#               define f5data ((struct fts3rec_v5 *)fdata)
		unsigned int has_f5data; /* boolean: is f5data is valid? */
                struct ftver ftv;
#            endif /* } */
#                  define INDEX       0
#                  define UNIX_SECS   1
#                  define EXPORTER    2
#                  define SRCADDR     3
#                  define DSTADDR     4
#                  define INPUT_IF    5
#                  define OUTPUT_IF   6
#                  define SRCPORT     7
#                  define DSTPORT     8
#                  define PKTS        9
#                  define BYTES       10
#                  define NEXTHOP     11
#                  define STARTIME    12
#                  define ENDTIME     13
#                  define PROTOCOL    14
#                  define TOS         15
#                  define SRC_AS      16
#                  define DST_AS      17
#                  define SRC_MASK    18
#                  define DST_MASK    19
#                  define TCP_FLAGS   20
#                  define ENGINE_TYPE 21
#                  define ENGINE_ID   22
#                  define RAW         23
#                  define ICMPTYPE    24
#                  define ICMPCODE    25
#                  define START_MSECS 26
#                  define END_MSECS   27
#                  define DURATION_SECS 28
#                  define DURATION_MSECS 29
#                  define RESERVED    30 /* placeholder for last var */
		SV *vars[RESERVED];
	CODE:
		if (2 > items ||
                    !SvROK(wanted) ||
                    SVt_PVCV != SvTYPE(SvRV(wanted))) {
		   croak("Usage: find(CODEREF, [CODEREF], FILE [...])");
		}

		if (SvROK(ST(arg)) &&
                    SVt_PVCV == SvTYPE(SvRV(ST(arg)))) { /* CODE */
		   perfile = ST(arg);
		   arg++;
		}

		verbose = SvIV(perl_get_sv("Cflow::verbose", TRUE));

		vars[INDEX] = perl_get_sv("Cflow::index", TRUE);
		vars[UNIX_SECS] = perl_get_sv("Cflow::unix_secs", TRUE);
		vars[EXPORTER] = perl_get_sv("Cflow::exporter", TRUE);
		vars[SRCADDR] = perl_get_sv("Cflow::srcaddr", TRUE);
		vars[DSTADDR] = perl_get_sv("Cflow::dstaddr", TRUE);
		vars[INPUT_IF] = perl_get_sv("Cflow::input_if", TRUE);
		vars[OUTPUT_IF] = perl_get_sv("Cflow::output_if", TRUE);
		vars[SRCPORT] = perl_get_sv("Cflow::srcport", TRUE);
		vars[DSTPORT] = perl_get_sv("Cflow::dstport", TRUE);
		vars[PKTS] = perl_get_sv("Cflow::pkts", TRUE);
		vars[BYTES] = perl_get_sv("Cflow::bytes", TRUE);
		vars[NEXTHOP] = perl_get_sv("Cflow::nexthop", TRUE);
		vars[STARTIME] = perl_get_sv("Cflow::startime", TRUE);
		vars[START_MSECS] = perl_get_sv("Cflow::start_msecs", TRUE);
		vars[ENDTIME] = perl_get_sv("Cflow::endtime", TRUE);
		vars[END_MSECS] = perl_get_sv("Cflow::end_msecs", TRUE);
		vars[DURATION_SECS] = perl_get_sv("Cflow::duration_secs", TRUE);
		vars[DURATION_MSECS] = perl_get_sv("Cflow::duration_msecs", TRUE);
		vars[PROTOCOL] = perl_get_sv("Cflow::protocol", TRUE);
		vars[TOS] = perl_get_sv("Cflow::tos", TRUE);
		vars[SRC_AS] = perl_get_sv("Cflow::src_as", TRUE);
		vars[DST_AS] = perl_get_sv("Cflow::dst_as", TRUE);
		vars[SRC_MASK] = perl_get_sv("Cflow::src_mask", TRUE);
		vars[DST_MASK] = perl_get_sv("Cflow::dst_mask", TRUE);
		vars[TCP_FLAGS] = perl_get_sv("Cflow::tcp_flags", TRUE);
		vars[ENGINE_TYPE] = perl_get_sv("Cflow::engine_type", TRUE);
		vars[ENGINE_ID] = perl_get_sv("Cflow::engine_id", TRUE);
		vars[RAW] = perl_get_sv("Cflow::raw", TRUE);
		vars[ICMPTYPE] = perl_get_sv("Cflow::ICMPType", TRUE);
		vars[ICMPCODE] = perl_get_sv("Cflow::ICMPCode", TRUE);

		for (; arg < items; arg++) {
		   size_t len;
                   char *namep;
		   char name[PATH_MAX];
		   FILE *fp = (FILE *)0;
		   cflowrec flow;
                   int fd;

		   if (SVt_PV != SvTYPE(ST(arg))) {
		      croak("Usage: find(CODEREF, [CODEREF], FILE [...])");
		   }

                   namep = SvPV(ST(arg), len);
		   strncpy(name, namep, len);
		   name[len] = '\0';

		   if (0 == strcmp("-", name)) {
		      fd = STDIN_FILENO;
		   } else {
                      if (-1 == (fd = open(name, O_RDONLY, 0))) {
                         warn("open \"%s\": %s\n", name, strerror(errno));
                         continue;
                      }
		   }
                   /* xsubpp doesn't like this line to be blank */
#            ifdef OSU /* [ */
                   fterr_setid("Cflow"); /* FIXME - should be perl caller */
		   if (verbose) {
		      fterr_setfile(1, stderr);
		   } else {
		      fterr_setfile(0, (FILE *)0);
		   }
                   if (0 <= ftio_init(&fs, fd, FT_IO_FLAG_READ) &&
                       0 <= ftio_check_generic(&fs)) {
		      ftio_get_ver(&fs, &ftv);
		      has_f5data = (5 == ftv.d_version ||
			            6 == ftv.d_version ||
			            7 == ftv.d_version);
                   } else { /* FIXME - ifdef OSU, reading cflowd from stdin? */
                      /* assume the file is in cflowd's v5 format: */
                      ftio_close(&fs);
                      if (-1 == (fd = open(name, O_RDONLY, 0))) {
                         warn("open \"%s\": %s\n", name, strerror(errno));
                         continue;
                      }
		      fp = fdopen(fd, "r");
		      if ((FILE *)0 == fp) {
		         warn("fdopen \"%s\": %s", name, strerror(errno));
                         continue;
		      }
                   }
#            else /* ][ */
		   fp = fdopen(fd, "r");
		   if ((FILE *)0 == fp) {
		      warn("fdopen \"%s\": %s", name, strerror(errno));
                      continue;
		   }
#            endif /* ] */

		   /* call the per-file "hook" if one was supplied. */
		   if ((SV *)0 != perfile) {
                      ENTER;
                      SAVETMPS;

		      PUSHMARK(sp);
		      XPUSHs(sv_mortalcopy(ST(arg)));
		      PUTBACK;
		      perl_call_sv(perfile, G_VOID|G_DISCARD);
		      SPAGAIN;
		      PUTBACK;

                      FREETMPS;
                      LEAVE;
		   }

                   for/*ever*/ (;;) {
		      size_t results;
                      uint32_t index;
#            ifdef OSU /* [ */
		      struct fttime first, last;
                      if ((FILE *)0 == fp) {
		         fdata = ftio_read(&fs);
                         if ((void *)0 == fdata) {
                            break;
                         }
			 first = ftltime(fdata->sysUpTime,
				         fdata->unix_secs,
				         fdata->unix_nsecs,
				         fdata->First);
			 last =  ftltime(fdata->sysUpTime,
				         fdata->unix_secs,
				         fdata->unix_nsecs,
				         fdata->Last);

			 /* { required for $Cflow::raw: */
			 /*
			  * FIXME? make $Cflow::raw a tied variable so
			  * that a performance penalty (because of all
			  * the htonl, htons calls below) is not incurred
			  * if the user doesn't even reference $Cflow::raw.
			  */
                         flow.index = htonl(expected_entry_mask);
                         flow.rtraddr = htonl(fdata->exaddr);
                         flow.srcaddr = htonl(fdata->srcaddr);
                         flow.dstaddr = htonl(fdata->dstaddr);
                         flow.nexthop = htonl(fdata->nexthop);
                         flow.input_if = htons(fdata->input);
                         flow.output_if = htons(fdata->output);
                         flow.pkts = htonl(fdata->dPkts);
                         flow.bytes = htonl(fdata->dOctets);
                         flow.starttime = htonl(first.secs);
                         flow.endtime = htonl(last.secs);
                         flow.srcport = htons(fdata->srcport);
                         flow.dstport = htons(fdata->dstport);
                         flow.protocol = fdata->prot;
                         flow.tos = fdata->tos;
                         flow.tcp_flags = fdata->tcp_flags;
#if 0 /* FIXME */
  u_int8  tcp_retx_cnt;   /* Number of mis-seq with delay > 1sec */
  u_int8  tcp_retx_secs;  /* Cumulative secs between mis-sequenced pkts */
  u_int8  tcp_misseq_cnt; /* Number of mis-sequenced tcp pkts seen */
#endif
			 if (has_f5data) {
                            flow.src_as = htons(f5data->src_as);
                            flow.dst_as = htons(f5data->dst_as);
                            flow.src_mask = f5data->src_mask;
                            flow.dst_mask = f5data->dst_mask;
                            flow.engine_type = f5data->engine_type;
                            flow.engine_id = f5data->engine_id;
			 } else { /* this info is unavailable: */
                            flow.src_as = 0;
                            flow.dst_as = 0;
			    /* FIXME? do class A,B,C rules?: */
                            flow.src_mask = 0;
                            flow.dst_mask = 0;
			 }
                         /* FIXME? handle fdata->drops */
		         sv_setpvn(vars[RAW], (char *)&flow, (sizeof flow) - 1);
			 /* } */
		         sv_setuv(vars[INDEX], expected_entry_mask);
		         sv_setuv(vars[EXPORTER], fdata->exaddr);
		         sv_setuv(vars[SRCADDR], fdata->srcaddr);
		         sv_setuv(vars[DSTADDR], fdata->dstaddr);
		         sv_setuv(vars[INPUT_IF], fdata->input);
		         sv_setuv(vars[OUTPUT_IF], fdata->output);
		         sv_setuv(vars[SRCPORT], fdata->srcport);
		         sv_setuv(vars[DSTPORT], fdata->dstport);
		         sv_setuv(vars[PKTS], fdata->dPkts);
		         sv_setuv(vars[BYTES], fdata->dOctets);
		         sv_setuv(vars[NEXTHOP], fdata->nexthop);
		         sv_setuv(vars[STARTIME], first.secs);
		         sv_setuv(vars[ENDTIME], last.secs);
			 sv_setuv(vars[START_MSECS], first.msecs);
			 sv_setuv(vars[END_MSECS], last.msecs);
		         sv_setuv(vars[PROTOCOL], fdata->prot);
		         sv_setuv(vars[TOS], fdata->tos);
			 if (has_f5data) {
		            sv_setuv(vars[SRC_AS], f5data->src_as);
		            sv_setuv(vars[DST_AS], f5data->dst_as);
		            sv_setuv(vars[SRC_MASK], f5data->src_mask);
		            sv_setuv(vars[DST_MASK], f5data->dst_mask);
		            sv_setuv(vars[ENGINE_TYPE], f5data->engine_type);
		            sv_setuv(vars[ENGINE_ID], f5data->engine_id);
			 }
		         sv_setuv(vars[TCP_FLAGS], fdata->tcp_flags);

		         sv_setuv(vars[UNIX_SECS], fdata->unix_secs);
		         if (1 == fdata->prot) { /* ICMP */
		            sv_setuv(vars[ICMPTYPE], fdata->dstport >> 8);
		            sv_setuv(vars[ICMPCODE], 0xff & fdata->dstport);
		         }
		         sv_setuv(vars[DURATION_SECS],
				  (fdata->Last - fdata->First) / 1000);
		         sv_setuv(vars[DURATION_MSECS],
				  (fdata->Last - fdata->First) % 1000);
                      } else {
#            endif /* ] */
		         if (1 != fread(&flow, (sizeof flow) - 1, 1, fp)) {
                            break;
                         }
                         index = ntohl(flow.index);
                         if (index != expected_entry_mask) {
                            if (verbose) {
                             warn("%s: Invalid index in cflowd flow file: 0x%X!"
				    " Version 5 flow-export is required"
				    " with *all* fields being saved.\n",
				    name, index);
                            }
                            goto next_file_label;
                         }
		         sv_setuv(vars[INDEX], index);
		         sv_setpvn(vars[RAW], (char *)&flow, (sizeof flow) - 1);
		         sv_setuv(vars[EXPORTER], ntohl(flow.rtraddr));
		         sv_setuv(vars[SRCADDR], ntohl(flow.srcaddr));
		         sv_setuv(vars[DSTADDR], ntohl(flow.dstaddr));
		         sv_setuv(vars[INPUT_IF], ntohs(flow.input_if));
		         sv_setuv(vars[OUTPUT_IF], ntohs(flow.output_if));
		         sv_setuv(vars[SRCPORT], ntohs(flow.srcport));
		         sv_setuv(vars[DSTPORT], ntohs(flow.dstport));
		         sv_setuv(vars[PKTS], ntohl(flow.pkts));
		         sv_setuv(vars[BYTES], ntohl(flow.bytes));
		         sv_setuv(vars[NEXTHOP], ntohl(flow.nexthop));
		         sv_setuv(vars[STARTIME], ntohl(flow.starttime));
		         sv_setuv(vars[ENDTIME], ntohl(flow.endtime));
		         sv_setuv(vars[PROTOCOL], flow.protocol);
		         sv_setuv(vars[TOS], flow.tos);
		         sv_setuv(vars[SRC_AS], ntohs(flow.src_as));
		         sv_setuv(vars[DST_AS], ntohs(flow.dst_as));
		         sv_setuv(vars[SRC_MASK], flow.src_mask);
		         sv_setuv(vars[DST_MASK], flow.dst_mask);
		         sv_setuv(vars[TCP_FLAGS], flow.tcp_flags);
		         sv_setuv(vars[ENGINE_TYPE], flow.engine_type);
		         sv_setuv(vars[ENGINE_ID], flow.engine_id);

		         sv_setuv(vars[UNIX_SECS], ntohl(flow.endtime));
		         if (1 == flow.protocol) { /* ICMP */
		            sv_setuv(vars[ICMPTYPE], ntohs(flow.dstport) >> 8);
		            sv_setuv(vars[ICMPCODE], 0xff & ntohs(flow.dstport));
		         }
		         sv_setuv(vars[DURATION_SECS],
				  ntohl(flow.endtime) - ntohl(flow.starttime));
#            ifdef OSU /* [ */
                      }
#            endif /* ] */
		      total++;

                      ENTER;
                      SAVETMPS;

		      PUSHMARK(sp);
		      PUTBACK;
		      results = perl_call_sv(wanted, G_SCALAR|G_NOARGS);
		      SPAGAIN;
		      if (1 == results && POPi != 0) {
			 n++;
		      }
		      PUTBACK;

                      FREETMPS;
                      LEAVE;
		   }

                next_file_label:
                   if ((FILE *)0 != fp) {
		      if (STDIN_FILENO != fd) {
		         fclose(fp);
                         fp = (FILE *)0;
			 fd = -1;
                      }
		   } else {
		      if (STDIN_FILENO != fd) {
                         close(fd);
#            ifdef OSU /* [ */
                         ftio_close(&fs);
#            endif /* ] */
                      }
                      fd = -1;
                   }
		}
		sprintf(retval, "%u/%u", (unsigned)n, (unsigned)total);
		RETVAL = retval;
	OUTPUT:
		RETVAL
