#!/usr/bin/perl
#
# perl script to look at all interfaces and list their indexes
#
# william.s.yu@ieee.org
#

use strict;
use Net::SNMP::Interfaces;
use Getopt::Std;

my %opts = ();
getopt('hc', \%opts);
die "Usage: interface-peek.pl -h host -c community"
    unless exists($opts{h}) && exists($opts{c});

my $interfaces = Net::SNMP::Interfaces->new(Hostname => $opts{h},
                                            Community => $opts{c} );

my @ifnames = $interfaces->all_interfaces();

foreach my $element (@ifnames) {
   printf ("%4.4s %15.15s",$element->index,$element->ifDescr);
   printf (" %4.4s",($element->ifAdminStatus==1)?"UP":"DOWN");
   printf (" %10.10s",$element->ifSpeed);
   printf (" %15.15s %15.15s",$element->ifInOctets,$element->ifOutOctets);
   printf (" %7.7s", $element->ifOutQLen);
   printf ("\n");
}
