#!/usr/bin/perl
# generated by william.s.yu@ieee.org
# 
# quick perl hack for displaying flow tools flows in summary form
# for quick analysis for Inter.net Philippines
#
# output displays the clients based on a client description file
# and their total usage for the day, their peak usage in a
# fifteen minute interval and their average daily throughput in 
# megabites/second
#

use strict;
use Date::Manip;
my $version = "0.16";

# configuration data that must be defined
my $flowbindir = "/usr/local/netflow/bin";
my $resultsdir = "/var/netflow/results";
my $aclfile = "/var/netflow/clients/acl.inter.net";
my $debugfile = "debug.out";
my $descfile = "/var/netflow/clients/client6.conf";
my $flowdir = "/var/netflow";
my $tmpdir = "/tmp";
my $userfilename = ".tmp.user";
my $tmpfile = ".tmp.file";
my $tmpfile2 = ".tmp.file.2";
my @router;
$router[0]="192.168.0.1";
$router[1]="192.168.0.2";

# people to get email of flow stats
my @maillist;
$maillist[0]="madridj\@team.ph.inter.net";

my %interfaces;
$interfaces{"192.168.0.1"} = "17";
$interfaces{"192.168.0.2"} = "3,10";

# routine to get the date in the proper format
my ($dummy,$day,$month,$year);
my $date = &ParseDate("yesterday");  
my $datestring = &UnixDate($date,"%Y") . "-" . &UnixDate($date,"%m") . "-" . &UnixDate($date,"%d");
my $reportfile = "report." . $datestring . "." . $version;
my $graphfile = "graph." . $datestring . "." . $version;

# variables 
my $tempstring = $datestring;
my $flowsubstring = "ft-v05." . $tempstring;
my ($flowfile,$userfile,$data);
my ($octets,$packets,$mbytes);
my ($element,$element2);
my ($e1,$e2,$e3,$e4,$e5,$e6);
my @containers;

# data hashes 
my %usage;
my %peak;
my ($rate,$rate2);

format OUT=
@<<<<<<<<<<< @<<<<<<<<<<< @<<<<<<<< @<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<
$element, $usage{$element}, $peak{$element}, $rate, $rate2
.

# creating temporary directory
if (-e $tmpdir . "/.flow") {
  system("rm -rf $tmpdir/.flow"); 
} 

system("mkdir $tmpdir/.flow");

open(CLIENT, "> $resultsdir/$graphfile")
    or die "Error: $!\n";

# go through all the router directories
foreach $element (@router) {
  if (-e $flowdir."/".$element) {
  } else {
     print "Directory does not exist: " . $flowdir . "/" . $element."\n";
     exit;
  }      
 
  system("ls $flowdir/$element/$flowsubstring* > $flowdir/$tmpfile");
  
  open (FLOW, "< $flowdir/$tmpfile");
  while (1) {
    last unless $flowfile = <FLOW>;
    chomp($flowfile);
   
    system("cd $tmpdir/.flow; $flowbindir/flow-filter -f $aclfile -D ours -i $interfaces{$element} < $flowfile|$flowbindir/flow-split -f $descfile\n");
   
    ($e1,$e2,$e3,$e4,$e5,$e6) = split(/\./,$flowfile);
 
    system("ls $tmpdir/.flow > $flowdir/$userfilename"); 

    open(USER, "< $flowdir/$userfilename") 
        or die "Error (".$userfilename. "): $1.\n";
    while(1) {
      last unless $userfile = <USER>;
      chomp($userfile);

      system("$flowbindir/flow-stat -f15 < $tmpdir/.flow/$userfile > $flowdir/$tmpfile2");

      open(DATA, "< $flowdir/$tmpfile2") or die "Error (".$tmpfile2."): $!\n";
      while (1) {
	last unless $data = <DATA>;
	chomp($data);

	# remove trailing spaces
	$_ = $data;
        s/\s{2,100}/ /;
        s/\s{2,100}/ /;
        $data = $_;
                
        ($octets,$packets,$mbytes)=split(/ /,$data);
        if ($octets ne "#") {
	   $usage{$userfile} += $octets;
	   if ($peak{$userfile} < $octets) {
	      $peak{$userfile} = $octets;
	   }
	   print CLIENT $element . " " . $tempstring ." " . $e6 . " ";
	   print CLIENT $userfile . " " . $octets . "\n";
        }
      }
      close(DATA);	
    }
    close(USER);
    system("rm -rf $tmpdir/.flow/*");
  }
  close(FLOW);

  # partial output to temporary file per router
  open(ROUTER,"> $flowdir/.tmp.$element") 
      or die "Error generating temp file: $!\n";
  @containers = keys (%usage);
  foreach $element2 (@containers) {
    print ROUTER $element2 . " " . $usage{$element2} . " " . $peak{$element2} ."\n";
    delete $usage{$element2};
    delete $peak{$element2};
  } 
  close(ROUTER);

}

# re-read all files from router temporary files
my ($user_r,$usage_r,$peak_r);

foreach $element (@router) {
  open(ROUTER, "< $flowdir/.tmp.$element")
      or die "Error re-reading temp router file: $!\n";
  while (1) {
    last unless $data = <ROUTER>;
    chomp($data);

    ($user_r,$usage_r,$peak_r) = split(/ /,$data);
    $usage{$user_r} += $usage_r;
    if ($peak{$user_r} < $peak_r) {
       $peak{$user_r} = $peak_r;
    }
  }
}

close(CLIENT);

my ($total_rate,$total_bytes,$total_peak);

# generate results file
open(OUT, "> $resultsdir/$reportfile")
    or die "Error: $!\n";
@containers = keys (%usage);
foreach $element (@containers) {
  $rate = ($usage{$element}*8)/(1024*60*60*24);
  $rate2 = ($peak{$element}*8)/(1024*60*15);
  $total_rate += $rate;
  $total_bytes += $usage{$element};
  $total_peak += $peak{$element};
  write(OUT);
  delete $usage{$element};
  delete $peak{$element};     
}

# display the sum

$element = "TOTAL";
$usage{$element} = $total_bytes;
$peak{$element} = $total_peak;
$rate = $total_rate;
$rate2 = "";
write(OUT);

close(OUT);

# email results to the following people
foreach $element (@maillist) {
  system("cat $resultsdir/$reportfile | mail -s NETFLOW $element");
}

# cleanup code
if (-e $flowdir."/".$tmpfile2) {
        unlink $flowdir . "/" . $tmpfile2;
}

if (-e $flowdir."/".$userfilename) {
        unlink $flowdir . "/" . $userfilename;
}

if (-e $flowdir."/".$tmpfile) {
	unlink $flowdir . "/" . $tmpfile;
}

if (-e $tmpdir ."/.flow") {
	system("rm -rf $tmpdir/.flow");
}

system("rm -rf $flowdir/.tmp.*");
system("rm -rf $tmpdir/.tmp.graph.*");
