#!/usr/bin/perl

use strict;
use Net::Patricia;

my $pt = new Net::Patricia;

my (@list, %track);

# Round 1. Load into the tree, check for dups
while (defined (my $line = <STDIN>)) {
  chomp ($line);
  my @a = split (/\s+/, $line);

  foreach my $net (@a[1..$#a]) {
    if ($track{$net}) {
      print "Dup for ", $net, ": ", $a[0], " ", $track{$net}, "\n";
    }
    else {
      $track{$net} = $a[0];
      $pt->add_string($net, [$a[0], $net]);
    }
  }
  push (@list, @a[1..$#a]);
}

# Round 2. Check for overlaps
foreach my $net (@list) {
  my $pn = $pt->match_string($net);
  if ($pn && ($pn->[1] ne $net)) {
    print "Overlap for ", $net, ": ", $pn->[0], " ", $pn->[1], "\n";
  }
}
