/*

  flow-cidr is a redone version of flow-split that work similarly to 
  flow-filter however, it accepts a definition file with a format
  defined below

  file on command line will contain:

  file1 net1 net2 net3...
  file2 net1 net2 net3...
 
 */

/* generic includes */
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <time.h>
#include <fcntl.h>
#include <string.h>

/* network related includes */
#include <netinet/in.h>
#include <netdb.h>
/* flow-tools related includes */
#include <config.h>
#include "ftlib.h"
#include "sym.h"
#include "fmt.h"

/* patricia tree related includes */
#include "patricia.h"

/* function declarations */
void usage();

int main(int argc, char *argv[])
{
  extern char *optarg;
  struct ftio ftio;

  char *inputfile;
  char *clientname;
  char *ipblock;/*JRLEE Added for -i option*/
  FILE *desc_file;
  int out_fd,i;
  struct ftio others_file;
  struct fts3rec_v5 *rec;
  char buf[161];
  patricia_tree_t *pt;
  patricia_node_t *pn;
  prefix_t *pref;
  struct ftver ftv;
  struct ftset ftset;
  int opt;/* added by jrlee ... maybe I should use a smaller data type :) */
  int clientname_exist=0;
  if (argc <= 1) {
        usage();
        return(0);
  }

  while ((i = getopt(argc, argv, "f:D:i:vh")) != -1)
  switch (i) {
    case 'v': 
      printf("Version 0.01 Copyright 2001 William Emmanuel S. Yu\n");
      return(0);
      break;
    case 'f':
      inputfile = optarg;
      break;
    case 'D':
      opt=2;
      /*  printf(*opt);*/
      clientname = optarg;
      break;
    case 'h':
    default:
      usage();
      return(0);
      break;
    case 'i':
      opt=1;
      /* printf(*opt);*/
    ipblock = optarg;
    	break;
  }

  if (((desc_file = fopen(inputfile, "r")) == NULL)&& (opt!=1)) {
    fprintf (stderr, "could not open description filename: %s\n", argv[1]);
    return 1;
  }

  /* generate the output stream for the match packets. */
  ftset_init(&ftset, 0);
  memset(&ftv, 0, sizeof(ftv));
  ftv.s_version = FT_IO_SVERSION;
  ftv.d_version = 5;
  ftv.agg_method = 1;
  ftv.agg_version = 2;

  out_fd = 1;

  if (ftio_init(&others_file, out_fd, FT_IO_FLAG_WRITE) < 0)
    {
     fprintf (stderr, "cannot initialize for writing: others.dump\n");
     return 1;
  }

  if (ftio_set_ver(&others_file, &ftv) < 0) {
     fprintf (stderr, "cannot set version: others.dump\n");
     return 1;
  }

  ftio_set_byte_order(&others_file, ftset.byte_order);
  ftio_set_streaming(&others_file, 1);

  if (ftio_write_header(&others_file) < 0) {
     fprintf (stderr, "cannot write header: others.dump\n");
     return 1;
  }
  /* end of segment to initialize others file */
  if (opt!=1){
  /** 
        this segment parses the configuration file 
        the format of the configuration file is as follows:

        filename prefix1 prefix2 prefix3
  */
  pt = New_Patricia(32);

  while (fgets (buf, 160, desc_file) != NULL) {
    char *s, *s2;
    char *client_string;

    /* Format: filename prefix1 prefix2 prefix3... */

    s = strchr(buf, '\n');
    *s = 0;

    s = strchr(buf, ' ');
    if (s == NULL) 
      break;

    /* Null terminate the filename and move to the first prefix */
    *s++ = 0; 

    while (s != NULL) {
      s2 = strchr(s,' ');
      if (s2 != NULL) { 
	*s2++=0;
      }

#ifdef DEBUG
      printf("s = %s.\n",s);
      printf("s2 = %s.\n",s2);
#endif DEBUG

      if ((pref = ascii2prefix(AF_INET, s)) == NULL) {
	fprintf (stderr, "invalid prefix: %s\n", s);
	return 1;
      }

      if ((pn = patricia_lookup(pt, pref)) == NULL) {
	fprintf (stderr, "could not create node for prefix: %s\n", s);
      }

      /* All we really want to store */
      client_string = malloc(sizeof(buf)+1);
      strcpy(client_string,buf);
      pn->data = client_string;
      s = s2;
      if(opt!=1){  
    if (strcmp(client_string,clientname)==0){
         clientname_exist = 1;
    } 
      }
    }
    
  }
  
  fclose (desc_file);
  /* end generating patricia tree */ 
  }
  if (opt!=1){
  if (clientname_exist ==0){
     fprintf(stderr,"Client name doesn't exist!!!\n");
     exit(1);
  }
  }

  /* At this point we have the tree */
  /* read flowfile from stdin */
  if (ftio_init(&ftio, 0, FT_IO_FLAG_READ) < 0) {
    fprintf(stderr, "ftio_init(): failed\n");
    exit (1);
  }

  while ((rec = ftio_read(&ftio))) {
    prefix_t *pref_out,pref_tmp;
    char* temp_string;

    /* Compute the following for a valid address, jrlee */
    if(opt==1){
      u_int netmask;

      pref_tmp.add.sin.s_addr = rec->dstaddr;
      pref_tmp.bitlen = 32;

      pref_out=ascii2prefix(AF_INET,ipblock);
      pref_out->add.sin.s_addr = ntohl(pref_out->add.sin.s_addr);
      netmask = (0xffffffff ^ ((1 << (32 - pref_out->bitlen)) - 1));
      pref_tmp.add.sin.s_addr &= netmask;
      pref_tmp.bitlen=32;

      if (pref_out->add.sin.s_addr==pref_tmp.add.sin.s_addr){
	if(!ftio_write(&others_file, rec)) {
	    fprintf(stderr,"Error writing flow file.\n");
	    exit(-1);
	}
      }
    }
  
    
    /* FIXME - must be able to change this to srcaddr later */
    if(opt!=1){
      pref_tmp.add.sin.s_addr = ntohl(rec->dstaddr);
      pref_tmp.bitlen = 32;
   
      if ((pn = patricia_search_best(pt, &pref_tmp)) != NULL) {
	temp_string = (char *)((struct ftio *)pn->data);
	if ( strcmp(temp_string,clientname) == 0 )
	  if(!ftio_write(&others_file, rec)) {
	    fprintf(stderr,"Error writing flow file.\n");
	    exit(-1);
	  }
      }

    }
       
    
  }   
  ftio_close(&others_file);
  
  return 0;

} /* main */


/* 
        usage() - displayed usage message 
 */


void usage()
{
  fprintf(stderr, "flow-cidr:\n\n");
  fprintf(stderr, " -f filename  definition filename\n");
  fprintf(stderr, " -D client	 destination client\n");
  fprintf(stderr, " -i ipblcok   destination ip \n ");
  fprintf(stderr, " -v           show version number\n");
  fprintf(stderr, " -h           help\n");
  fprintf(stderr, "\n");
} /* usage() */
