#include <stdio.h>
#include "bytes.h"
#include "fmt.h"
#include "flow-profile.h"
#include "sym.h"

profile_dump(prof, options, tally, name, noctets, nflows, npackets, t_octets,
  t_packets)
struct profile *prof;
int options, tally;
char *name;
u_int64 *nflows, *noctets, *npackets;
u_int64 *t_octets, *t_packets;
{

  int32 x, i2;
  char fmt_buf[256];
  u_int64 total64;
  extern struct sym_table sym_ipprot[];
  extern struct sym_table sym_tcp[];
  extern char cc;
  
  int ret, len;

  printf("%-30.30s  ", name);

  if (options & OPT_PERCENT) {

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_octets[DIR_OUT][x];
    printf("%-6.3f       ", (double)total64/(double)noctets[DIR_OUT]*100);
    t_octets[DIR_OUT] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_packets[DIR_OUT][x];
    printf("%-6.3f         ", (double)total64/(double)npackets[DIR_OUT]*100);
    t_packets[DIR_OUT] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_octets[DIR_IN][x];
    printf("%-6.3f       ", (double)total64/(double)noctets[DIR_IN]*100);
    t_octets[DIR_IN] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_packets[DIR_IN][x];
    printf("%-6.3f\n", (double)total64/(double)npackets[DIR_IN]*100);
    t_packets[DIR_IN] += total64;

  } else {

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_octets[DIR_OUT][x];
    len = fmt_uint64(fmt_buf, total64, FMT_PAD_RIGHT);
    fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
    t_octets[DIR_OUT] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_packets[DIR_OUT][x];
    len += fmt_uint64(fmt_buf+len, total64, FMT_PAD_RIGHT);
    fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
    fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
    t_packets[DIR_OUT] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_octets[DIR_IN][x];
    len += fmt_uint64(fmt_buf+len, total64, FMT_PAD_RIGHT);
    fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
    t_octets[DIR_IN] += total64;

    for (x = 0, total64 = 0; x < 256; ++x)
      total64 += prof->ip_prot_packets[DIR_IN][x];
    len += fmt_uint64(fmt_buf+len, total64, FMT_PAD_RIGHT);
    t_packets[DIR_IN] += total64;
    puts(fmt_buf);

    if (options & OPT_LONG) {
      printf("\n%c IP Protocol\n", cc);

      for (x = 0; x < 256; ++x) {

        if ((!prof->ip_prot_octets[DIR_OUT][x]) &&
          (!prof->ip_prot_packets[DIR_OUT][x]) &&
          (!prof->ip_prot_octets[DIR_IN][x]) &&
          (!prof->ip_prot_packets[DIR_OUT][x]))
          continue;

        len = 0;

        len += fmt_uint64(fmt_buf+len, prof->ip_prot_octets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->ip_prot_packets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->ip_prot_octets[DIR_IN][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->ip_prot_packets[DIR_IN][x],
          FMT_PAD_RIGHT);

        printf("  %-10.10s                    %s\n",
          sym_pr_uint16(&sym_ipprot,
          (u_int16)x, FMT_JUST_LEFT, options), fmt_buf);
      } /* x */

      len = fmt_uint64(fmt_buf, prof->tcp_flag_syn[DIR_OUT],
        FMT_JUST_LEFT);
      fmt_buf[len++] = '/';
      fmt_uint64(fmt_buf+len, prof->tcp_flag_syn[DIR_IN],
        FMT_JUST_LEFT);
      printf("\n%c TCP SYN (in/out)     %s\n", cc, fmt_buf);

      len = fmt_uint64(fmt_buf,
        prof->tcp_flag_syn_ack[DIR_OUT],
        FMT_JUST_LEFT);
      fmt_buf[len++] = '/';
      fmt_uint64(fmt_buf+len,
        prof->tcp_flag_syn_ack[DIR_IN],
        FMT_JUST_LEFT);
      printf("%c TCP SYN+ACK (in/out) %s\n", cc, fmt_buf);

#ifndef PROF_UDP_TCP_COMBINED
      printf("\n%c IP/UDP Ports < 1024\n", cc);

      for (x = 0; x < 1024; ++x) {

        if ((!prof->udp_port_octets[DIR_OUT][x]) &&
          (!prof->udp_port_packets[DIR_OUT][x]) &&
          (!prof->udp_port_octets[DIR_IN][x]) &&
          (!prof->udp_port_packets[DIR_IN][x]))
          continue;

        len = 0;

        len += fmt_uint64(fmt_buf+len, prof->udp_port_octets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->udp_port_packets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->udp_port_octets[DIR_IN][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len, prof->udp_port_packets[DIR_IN][x],
          FMT_PAD_RIGHT);

        printf("  %-10.10s                    %s\n",
          sym_pr_uint16(&sym_udp,
          (u_int16)x, FMT_JUST_LEFT, options), fmt_buf);

      } /* x */

      printf("\n%c IP/TCP Ports < 1024\n", cc);
#else
      printf("\n%c IP/TCP/UDP Ports < 1024\n", cc);
#endif /* PROF_UDP_TCP_COMBINED */

      for (x = 0; x < 1024; ++x) {

        if ((!prof->tcp_port_octets[DIR_OUT][x]) &&
          (!prof->tcp_port_packets[DIR_OUT][x]) &&
          (!prof->tcp_port_octets[DIR_IN][x]) &&
          (!prof->tcp_port_packets[DIR_IN][x]))
          continue;

        len = 0;

        len += fmt_uint64(fmt_buf+len,
          prof->tcp_port_octets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len,
          prof->tcp_port_packets[DIR_OUT][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len,
          prof->tcp_port_octets[DIR_IN][x],
          FMT_PAD_RIGHT);
        fmt_buf[len++] = ' '; fmt_buf[len++] = ' ';

        len += fmt_uint64(fmt_buf+len,
          prof->tcp_port_packets[DIR_IN][x],
          FMT_PAD_RIGHT);

        printf("  %-10.10s                    %s\n",
          sym_pr_uint16(&sym_tcp,
          (u_int16)x, FMT_JUST_LEFT, options), fmt_buf);

      } /* x */
      printf("\n");
    } /* OPT_LONG */
  }

} /* profile_dump */

