#include <sys/time.h>
#include "bytes.h"

#define TCPDUMP_MAGIC 0xa1b2c3d4
#define TCPDUMP_VERSION_MAJOR 2
#define TCPDUMP_VERSION_MINOR 2

struct pcap_file_header {
  u_long magic;
  u_short version_major;
  u_short version_minor;
  long thiszone;    /* gmt to local correction */
  u_long sigfigs;   /* accuracy of timestamps */
  u_long snaplen;   /* max length saved portion of each pkt */
  u_long linktype;
};

struct pcap_packet_header {
  struct timeval ts;  /* time stamp */
  u_long len;         /* length this packet (off wire) */
  u_long caplen;      /* length of portion present */
};

/* eth header */
struct pcap_data1 {
  /* eth header */
  u_int8 eth_dst[6];
  u_int8 eth_src[6];
  u_int16 eth_prot;
};

/* ip header */
struct pcap_data2 {
  u_int8 version;
  u_int8 tos;
  u_int16 len;
  u_int16 id;
  u_int16 flags_fragment;
  u_int8 ttl;
  u_int8 prot;
  u_int16 csum;
  u_int32 srcaddr;
  u_int32 dstaddr;
};

/* tcp header */
struct pcap_data3 {
  u_int16 srcport;
  u_int16 dstport;
  u_int32 hold1; /* seq */
  u_int32 hold2; /* ack */
  u_int32 hold3; /* data, reserved, flags, window */
  u_int32 hold4; /* csum, urg pointer */
  u_int32 hold5; /* options, padding */
};


/* udp header */
struct pcap_data4 {
  u_int16 srcport;
  u_int16 dstport;
  u_int32 hold1; /* len */
  u_int32 hold2; /* csum */
  u_int32 hold3; /* data ...*/
  u_int32 hold4; /* data ... */
  u_int32 hold5; /* data ... */
#ifdef XXX
  u_int32 hold6; /* data */
#endif /* XXX */
};


