#include <sys/types.h>
#include "bytes.h"

int hash_ip_init();
int hash_ip_dump();

#define HASH_IP_STAT 

struct hash_ip_addr {

  u_short seg;    /* segment pointer */
  u_short off;    /* offset */
#ifdef HASH_IP_STAT
  u_long  hits;
#endif /* HASH_IP_STAT */
};

struct hash_ip_rec {

  u_int32 addr;         /* ip address */
  u_int64 nflows;       /* # of flows */
  u_int64 noctets;      /* # of octets */
  u_int64 npackets;     /* # of packets */
  u_int64 etime;        /* elapsed time */

  struct hash_ip_addr next; /* next record */
};


struct hash_ip_table {

  struct hash_ip_addr head;    /* head pointer to free records */
  struct hash_ip_addr *table;  /* lookup table */
  char **data;                 /* hash data */
  u_short lastoff;             /* last offset before need new allocation */

};

  
/* add a record to the table, or update the current record */
int hash_ip_update();

/* free storage */
int hash_ip_free();

/* lookup next key */
int hash_ip_next();

/* display histogram if hash table */
int hash_ip_hist();

